package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.RecommendTargetAdvertDto;
import cn.com.duiba.tuia.core.api.dto.advert.RecommendTargetSlotStatDataDto;
import cn.com.duiba.tuia.core.api.dto.advert.SlotApplyTargetStatDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.SlotApplyTargetStatReq;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertBaseInfoDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.SlotApplyAdvertTargetDto;

import java.util.List;

/**
 * Created by huangch on 2018/7/2 09:51
 * description:申请广告定向媒体广告位类
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteSlotApplyAdvertTargetService {

    /**
     * 申请广告定向媒体广告位提交接口
     *
     * @param applyList 申请的定向广告位对应广告列表
     * @return true-成功，false-失败
     */
    Boolean commitApply(List<SlotApplyAdvertTargetDto> applyList);

    /**
     * 二次过滤推荐的有效广告
     *
     * @param advertIds 过滤的广告ID集合 必传不可为空
     * @param appId     推荐的媒体ID 必传不可为空
     * @param slotId    推荐的广告位ID 必传不可为空
     * @return 过滤之后的广告ID列表
     */
    List<RecommendTargetAdvertDto> filterRecommendAdvert(List<Long> advertIds, Long appId, Long slotId);

    /**
     * 通过广告id列表查询广告的名称和AE
     *
     * @param advertIds 查询的广告id列表 必传
     */
    List<AdvertBaseInfoDto> queryAdvertInfoByIds(List<Long> advertIds);

    /**
     * 分页查询广告位申请定向广告的统计报表数据，默认按消耗排序
     */
    RecommendTargetSlotStatDataDto pageQuerySlotApplyTargetStatData(SlotApplyTargetStatReq req) throws BizException;

    /**
     * 分页查询广告位申请定向广告的统计报表数据——分日查询，默认按日期排序
     */
    PageDto<SlotApplyTargetStatDto> pageQuerySlotApplyTargetStatDailyData(SlotApplyTargetStatReq req) throws BizException;
}
