package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.OrientationFocusAppConvertCostDto;
import cn.com.duiba.tuia.core.api.dto.req.FocusAppDataReqDto;
import cn.com.duiba.tuia.core.api.dto.statistics.FocusAppDataEntityDto;

import java.util.List;

/**
 * Created by huangch on 2019/1/29 15:26
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteOrientationFocusAppDataService {


    /**
     * 查询重点媒体汇总数据
     *
     * @return 配置汇总数据
     */
    FocusAppDataEntityDto queryFocusAppSummaryData(FocusAppDataReqDto reqDto);

    /**
     * 分页查询重点媒体数据
     *
     * @return
     */
    PageDto<FocusAppDataEntityDto> pageQueryFocusAppData(FocusAppDataReqDto reqDto);

    /**
     * 批量插入重点媒体转化出价
     */
    Integer batchInsertFocusAppConvertCost(List<OrientationFocusAppConvertCostDto> list);

    /**
     * 批量更新媒体转化出价
     *
     * @param list 更新列表 传入ID和convertCost
     * @return
     */
    Integer batchUpdateFocusAppConvertCost(List<OrientationFocusAppConvertCostDto> list);

    /**
     * 查询广告配置的重点媒体转化出价列表
     *
     * @param orientationId 配置ID
     * @param subtype       转化类型
     * @return
     */
    List<OrientationFocusAppConvertCostDto> selectOrientationFocusAppConvertCost(Long orientationId, Integer subtype);

}
