/**
 * 文件名： AccountSumInfo.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月30日 下午3:21:02
 */
package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告主概要信息.
 *
 * @author: leiliang
 * @version:
 */
public class AdvertiserSumInfoDto implements Serializable {

	private static final long serialVersionUID = 7859218758190682117L;

	/** 广告主ID. */
	private Long id;
	
	/** 广告主邮箱. */
	private String email;
	
	/** 广告主公司名称. */
	private String companyName;

	/** 广告主公司地址. */
	private String companyAddress;

	/** 广告主冻结状态:0：未冻结;1：冻结. */
	private Integer freezeStatus;
	
	/** 广告主邮箱状态:0：未验证;1：已验证. */
	private Integer emailStatus;
	
	/** 广告主审核状态:0：审核中;1：审核通过;2：审核拒绝. */
	private Integer checkStatus;
	
	/** 广告主营业执照号. */
	private String businessLicenseId;

	/** 广告主营业执照号. */
	private String businessLicenseName;

	/** 广告主营业执照照片. */
	private String businessLicenseUrl;
	
	/** 广告主联系人姓名. */
	private String linkman;
	
	/** 广告主联系人手机号. */
	private String linkmanPhone;
	
	/** 广告主联系人QQ. */
	private String linkmanQQ;
	
	/** 操作员名字.*/
	private String operatorName;

	/** 代理商公司名称. */
	private String  agentCompanyName;

	/** 广告主营业执照照片. */
	private String  businessLicensePic;

	/** 账户类型. */
	private Integer userType;

    /** 创建时间 */
    private String  gmtCreate;

    /** 代理商(广告主)等级 0为最顶级 */
    private Integer           accountLevel;

    /** 上级代理商层级连接，点分隔 */
    private String            accountLevelNum;

    private String auditor;

    private Date auditTime;

    private Date editTime;

    /** 收件邮箱 */
    private String receivingMailbox;

    /**
     * accountLevel.
     *
     * @return the accountLevel
     * @since JDK 1.8
     */
    public Integer getAccountLevel() {
        return accountLevel;
    }

    /**
     * accountLevel.
     *
     * @param accountLevel the accountLevel to set
     * @since JDK 1.8
     */
    public void setAccountLevel(Integer accountLevel) {
        this.accountLevel = accountLevel;
    }

    /**
     * accountLevelNum.
     *
     * @return  the accountLevelNum
     * @since   JDK 1.8
     */
    public String getAccountLevelNum() {
        return accountLevelNum;
    }

    
    /**
     * accountLevelNum.
     *
     * @param   accountLevelNum    the accountLevelNum to set
     * @since   JDK 1.8
     */
    public void setAccountLevelNum(String accountLevelNum) {
        this.accountLevelNum = accountLevelNum;
    }

    /**
     * gmtCreate.
     *
     * @return  the gmtCreate
     * @since   JDK 1.8
     */
    public String getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param   gmtCreate    the gmtCreate to set
     * @since   JDK 1.8
     */
    public void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public String getCompanyAddress() {
		return companyAddress;
	}

	public void setCompanyAddress(String companyAddress) {
		this.companyAddress = companyAddress;
	}

	public String getBusinessLicenseName() {
		return businessLicenseName;
	}

	public void setBusinessLicenseName(String businessLicenseName) {
		this.businessLicenseName = businessLicenseName;
	}

	public String getAgentCompanyName() {
		return agentCompanyName;
	}

	public void setAgentCompanyName(String agentCompanyName) {
		this.agentCompanyName = agentCompanyName;
	}

	public String getBusinessLicensePic() {
		return businessLicensePic;
	}

	public void setBusinessLicensePic(String businessLicensePic) {
		this.businessLicensePic = businessLicensePic;
	}

	public Integer getUserType() {
		return userType;
	}

	public void setUserType(Integer userType) {
		this.userType = userType;
	}

	/**
	 * @return the id
	 */
	public Long getId()
	{
		return id;
	}
	
	/**
	 * @param id the id to set
	 */
	public void setId(Long id)
	{
		this.id = id;
	}
	
	/**
	 * @return the email
	 */
	public String getEmail()
	{
		return email;
	}
	
	/**
	 * @param email the email to set
	 */
	public void setEmail(String email)
	{
		this.email = email;
	}
	
	/**
	 * @return the companyName
	 */
	public String getCompanyName()
	{
		return companyName;
	}
	
	/**
	 * @param companyName the companyName to set
	 */
	public void setCompanyName(String companyName)
	{
		this.companyName = companyName;
	}
	
	/**
	 * @return the freezeStatus
	 */
	public Integer getFreezeStatus()
	{
		return freezeStatus;
	}
	
	/**
	 * @param freezeStatus the freezeStatus to set
	 */
	public void setFreezeStatus(Integer freezeStatus)
	{
		this.freezeStatus = freezeStatus;
	}
	
	/**
	 * @return the emailStatus
	 */
	public Integer getEmailStatus()
	{
		return emailStatus;
	}
	
	/**
	 * @param emailStatus the emailStatus to set
	 */
	public void setEmailStatus(Integer emailStatus)
	{
		this.emailStatus = emailStatus;
	}
	
	/**
	 * @return the checkStatus
	 */
	public Integer getCheckStatus()
	{
		return checkStatus;
	}
	
	/**
	 * @param checkStatus the checkStatus to set
	 */
	public void setCheckStatus(Integer checkStatus)
	{
		this.checkStatus = checkStatus;
	}
	
	/**
	 * @return the businessLicenseId
	 */
	public String getBusinessLicenseId()
	{
		return businessLicenseId;
	}
	
	/**
	 * @param businessLicenseId the businessLicenseId to set
	 */
	public void setBusinessLicenseId(String businessLicenseId)
	{
		this.businessLicenseId = businessLicenseId;
	}
	
	public String getBusinessLicenseUrl() {
		return businessLicenseUrl;
	}

	public void setBusinessLicenseUrl(String businessLicenseUrl) {
		this.businessLicenseUrl = businessLicenseUrl;
	}

	/**
	 * @return the linkman
	 */
	public String getLinkman()
	{
		return linkman;
	}
	
	/**
	 * @param linkman the linkman to set
	 */
	public void setLinkman(String linkman)
	{
		this.linkman = linkman;
	}
	
	/**
	 * @return the linkmanPhone
	 */
	public String getLinkmanPhone()
	{
		return linkmanPhone;
	}
	
	/**
	 * @param linkmanPhone the linkmanPhone to set
	 */
	public void setLinkmanPhone(String linkmanPhone)
	{
		this.linkmanPhone = linkmanPhone;
	}
	
	/**
	 * @return the linkmanQQ
	 */
	public String getLinkmanQQ()
	{
		return linkmanQQ;
	}
	
	/**
	 * @param linkmanQQ the linkmanQQ to set
	 */
	public void setLinkmanQQ(String linkmanQQ)
	{
		this.linkmanQQ = linkmanQQ;
	}
	
	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

	public String getReceivingMailbox() { return receivingMailbox; }

	public void setReceivingMailbox(String receivingMailbox) { this.receivingMailbox = receivingMailbox; }

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString()
	{
		return ToStringBuilder.reflectionToString(this);
	}
	
}
