package cn.com.duiba.tuia.core.api.dto.advert;


import java.math.BigDecimal;
import java.util.Date;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * Created by huangch on 2017/8/25 10:05
 * description:
 *
 * @since JDK 1.6
 */
public class AdvertInfoDto extends BaseDto {

    private static final long serialVersionUID = 6732742837028438836L;

    /**
     * 广告主ID.
     */
    private Long accountId;

    //广告类型
    private Integer advertType;
    
    /**
     * 优惠券库存ID.
     */
    private Long duibaId;

    /**
     * 广告名称.
     */
    private String advertName;

    //广告推广链接
    private String promoteURL;

    /**
     * 广告审核状态:0：审核中;1：审核通过;2：审核拒绝.
     */
    private Integer checkStatus;

    /**
     * 广告来源 0：推啊平台 1：兑吧商品 2：兑吧卷库.
     */
    private Integer source;

    /**
     * 广告权重
     */
    private BigDecimal advertWeight;

    //是否开启广告失效异常提醒状态,0-关闭，1-开启,默认开启
    private Integer invalidRemindStatus;

    //是否开启广告消耗异常提醒状态,0-关闭，1-开启,默认开启
    private Integer consumeAbnRemindStatus;

    /** 兑吧审核：0：未审，1：已审 */
    private Integer duibaAudit;

    //拒绝原因
    private String refuseReason;

    /** 审核人 */
    private String auditor;

    /** 审核时间 */
    private Date auditTime;

    /** 修改时间 */
    private Date editTime;

    /** 进审修改时间 */
    private Date auditEditTime;

    /**广告失效标志 true代表失效*/
    private Boolean abate;

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }
    
    public Boolean getAbate() {
        return abate;
    }

    public void setAbate(Boolean abate) {
        this.abate = abate;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    /**
     * duibaAudit.
     *
     * @return  the duibaAudit
     * @since   JDK 1.8
     */
    public Integer getDuibaAudit() {
        return duibaAudit;
    }
    
    /**
     * duibaAudit.
     *
     * @param   duibaAudit    the duibaAudit to set
     * @since   JDK 1.8
     */
    public void setDuibaAudit(Integer duibaAudit) {
        this.duibaAudit = duibaAudit;
    }

    public Integer getInvalidRemindStatus() {
        return invalidRemindStatus;
    }

    public void setInvalidRemindStatus(Integer invalidRemindStatus) {
        this.invalidRemindStatus = invalidRemindStatus;
    }

    public Integer getConsumeAbnRemindStatus() {
        return consumeAbnRemindStatus;
    }

    public void setConsumeAbnRemindStatus(Integer consumeAbnRemindStatus) {
        this.consumeAbnRemindStatus = consumeAbnRemindStatus;
    }

    /**
     * accountId.
     *
     * @return  the accountId
     * @since   JDK 1.8
     */
    public Long getAccountId() {
        return accountId;
    }
    
    /**
     * accountId.
     *
     * @param   accountId    the accountId to set
     * @since   JDK 1.8
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getAdvertWeight() {
        return advertWeight;
    }

    public void setAdvertWeight(BigDecimal advertWeight) {
        this.advertWeight = advertWeight;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getDuibaId() {
        return duibaId;
    }

    public void setDuibaId(Long duibaId) {
        this.duibaId = duibaId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }


    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    public Date getAuditEditTime() {
        return auditEditTime;
    }

    public void setAuditEditTime(Date auditEditTime) {
        this.auditEditTime = auditEditTime;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

}
