/**
 * Project Name:tuia-core-api<br>
 * File Name:Tag.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:22:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req.advert;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.QueryDto;

/**
 * ClassName: NewTagDto <br/>
 * Function: 免费券广告查询条件. <br/>
 * date: 2018年1月15日 上午11:58:34 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class ReqValidFreeAdvertDto extends QueryDto {

    private static final long serialVersionUID = -6129405780826312907L;

    /** 数据源id */
    private Long              sourceId;

    /** 数据源id集合 */
    private List<Long>        sourceIds;

    /** 数据源类型：advert:广告,agent:代理商 */
    private String            sourceType;

    /** 广告的代理商id */
    private Long              agentId;

    public ReqValidFreeAdvertDto() {
        super();
    }

    public ReqValidFreeAdvertDto(Long sourceId, String sourceType, Integer rowStart, Integer pageSize) {
        super();
        this.sourceId = sourceId;
        this.sourceType = sourceType;
        super.setRowStart(rowStart);
        super.setPageSize(pageSize);
    }

    /**
     * sourceIds.
     *
     * @return the sourceIds
     * @since JDK 1.8
     */
    public List<Long> getSourceIds() {
        return sourceIds;
    }

    /**
     * sourceIds.
     *
     * @param sourceIds the sourceIds to set
     * @since JDK 1.8
     */
    public void setSourceIds(List<Long> sourceIds) {
        this.sourceIds = sourceIds;
    }

    /**
     * sourceId.
     *
     * @return the sourceId
     * @since JDK 1.8
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * sourceId.
     *
     * @param sourceId the sourceId to set
     * @since JDK 1.8
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * sourceType.
     *
     * @return the sourceType
     * @since JDK 1.8
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * sourceType.
     *
     * @param sourceType the sourceType to set
     * @since JDK 1.8
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * agentId.
     *
     * @return the agentId
     * @since JDK 1.8
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * agentId.
     *
     * @param agentId the agentId to set
     * @since JDK 1.8
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
