package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.app.AppPackageExceedAdvDto;
import cn.com.duiba.tuia.core.api.dto.app.AutoUpdateAppPackageDto;
import cn.com.duiba.tuia.core.api.dto.app.RecommendAppPackageDto;
import cn.com.duiba.tuia.core.api.dto.app.RecommendAppPkgRspDto;
import cn.com.duiba.tuia.core.api.dto.req.AppPkgUpdateDto;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/3/12
 * @function
 */
@AdvancedFeignClient
public interface RemoteRecommendAppPackageService {

    /**
     * 流量包开启推荐
     */
    Boolean setRecommendAppPackage(RecommendAppPackageDto recommendAppPackageDto);

    /**
     * 更新推荐状态(流量包管理处对流量包)
     */
    Boolean updateRecommendAppPackageStatus(Long appPackageId,Integer validateStatus);

    /**
     * 定向配置点击不再推荐,当前配置已经绑定了推荐广告,需要添加当前广告到 tb_exceed_advert
     */
    Boolean cancelRecommendAppPackage(AppPackageExceedAdvDto appPackageExceedAdvDto);

    /**
     * 新增或者删除推荐的流量包,需要将广告添加/移除 到tb_exceed_advert
     */
    void addRemoveRecommendAppPackage(List<Long> targetAppPkgIds,List<Long> limitAppPkgIds,Long orientPkgId);

    /**
     * 获取当前广告 满足推荐的流量包id
     * @param advertId
     * @param type 0定向流量包，1-限流流量包
     */
    List<RecommendAppPkgRspDto> getAllRecommendAppPackage(Long advertId,Integer type);

    /**
     * 更改定向流量包的更新方式(自动更新,手动更新)
     */
    Boolean changeAppPkgUpdateType(AutoUpdateAppPackageDto autoUpdateAppPackageDto);

    /**
     * 更改限流流量包的更新方式(自动更新,手动更新)
     */
    Boolean changeLimtAppPkgUpdateType(AutoUpdateAppPackageDto autoUpdateAppPackageDto);

    /**
     * 手动更新流量包
     */
    Boolean mannualUpdateAppPackage(AutoUpdateAppPackageDto autoUpdateAppPackageDto);

    /**
     * 获取更新详情
     */
    AutoUpdateAppPackageDto getUpdateAppPackageDetail(AutoUpdateAppPackageDto autoUpdateAppPackageDto);

    /**
     * 将指定的媒体添加到配置的限流中
     */
    void addAppToLimit(List<Long> orientIds,Long appId,Long advertId);

    /**
     * 获取所有自动更新的流量包
     */
    List<AutoUpdateAppPackageDto> getAllAutoUpdtePkg();

    /**
     * 批量修改流量包自动更新状态
     */
    void batchChangeAppPkgUpdateType(List<AppPkgUpdateDto> targetAppPkgUpdateDtos,List<AppPkgUpdateDto> limitAppPkgUpdateDtos,Long orientId);

    void testCache();

}
