package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AppFlowStrategyDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotEffectiveAdvertNumInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotFlowStrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by jzl on 18/4/2.
 */
@AdvancedFeignClient
public interface RemoteSlotFlowStrategyService {

    /**
     * 通过appId查询策略集合
     * @param appId
     * @return
     */
    DubboResult<List<SlotFlowStrategyDto>> getListByAppId(Long appId);

    /**
     * 查询单个广告位的策略
     * @param slotId
     * @return
     */
    DubboResult<SlotFlowStrategyDto> findSlotFlowStrategyDtoBySlotId(Long slotId);

    List<SlotFlowStrategyDto> selectBySlotIds(List<Long> slotIds);

    /**
     * 插入广告位流量策略
     *
     * @param  slotFlowStrategyDto
     */
    DubboResult<Boolean> insertOrUpdateSlotFlowStrategy(SlotFlowStrategyDto slotFlowStrategyDto);

    /**
     * 计算广告位的总广告数和有效广告数
     * @param slotIds
     * @return
     */
    List<SlotEffectiveAdvertNumInfoDto> handleSlotsAdvertNumInfo(List<Long> slotIds);

    /**
     * 根据appId查询下属的流量策略所有的广告位id
     * @param appId
     * @return
     */
    List<Long> getFlowStrategySlotIdsByAppId(Long appId);
}
