package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * Created by MichealWang on 2018/9/7 0007.
 */
@ApiModel("查询定向配置每日统计数据请求参数")
public class GetPackageDailyDataReq extends ByDateQueryReq {


    /** 广告ID. */
    @ApiModelProperty(value = "广告ID", required = true)
    private Long   advertId;

    @ApiModelProperty("广告名称")
    private String advertName;

    @ApiModelProperty("广告主ID集合")
    private List<Long> advertIds;

    @NotNull(message = "定向配置ID不为空")
    @ApiModelProperty("定向配置id")
    private  Long packageId;

    @ApiModelProperty("定向配置名称")
    private  String packageName;

    @ApiModelProperty("广告类型")
    private  Integer advertType;

    public Integer getAdvertType() { return advertType; }

    public void setAdvertType(Integer advertType) { this.advertType = advertType; }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }
}
