/**
 * Project Name:tuia-domain<br>
 * File Name:AdvertPlanPeriodDO.java<br>
 * Package Name:cn.com.duiba.tuia.domain.dataobject<br>
 * Date:2016年7月8日上午10:23:14<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto;

/**
 * ClassName: AdvertPlanPeriodDO <br/>
 * Function: 投放时段. <br/>
 * date: 2016年7月8日 上午10:23:14 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class AdvertPlanPeriodDto extends BaseDto {
	
    private static final long serialVersionUID = 1L;

    /** 广告ID. */
    private Long              advertId;

    /** 时段开始时间. */
    private String            startHour;

    /** 时段结束时间. */
    private String            endHour;

    /** 废弃,使用 periodValue */
    @Deprecated
    private Integer           launchLimit;
    
    /** 定向配置包主键 */
    private Long 			  advertPackageId;
    /**投放时段类型   tuia-core@AdvertPkgPeriodTypeEnum*/
    private String periodType;
    /**投放时段值  value ="hourCoupon" 则当前值是 "每小时发券量" or value="countCoupon" 总发券量 or value="hourBudget"每小时预算 or value="countBudget"总预算*/
    private Long periodValue;

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.7
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.7
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * startHour.
     *
     * @return the startHour
     * @since JDK 1.7
     */
    public String getStartHour() {
        return startHour;
    }

    /**
     * startHour.
     *
     * @param startHour the startHour to set
     * @since JDK 1.7
     */
    public void setStartHour(String startHour) {
        this.startHour = startHour;
    }

    /**
     * endHour.
     *
     * @return the endHour
     * @since JDK 1.7
     */
    public String getEndHour() {
        return endHour;
    }

    /**
     * endHour.
     *
     * @param endHour the endHour to set
     * @since JDK 1.7
     */
    public void setEndHour(String endHour) {
        this.endHour = endHour;
    }

    /**
     * launchLimit.
     *
     * @return the launchLimit
     * @since JDK 1.7
     */
    @Deprecated
    public Integer getLaunchLimit() {
        return launchLimit;
    }

    /**
     * launchLimit.
     *
     * @param launchLimit the launchLimit to set
     * @since JDK 1.7
     */
    @Deprecated
    public void setLaunchLimit(Integer launchLimit) {
        this.launchLimit = launchLimit;
    }

    public Long getAdvertPackageId() {
		return advertPackageId;
	}

	public void setAdvertPackageId(Long advertPackageId) {
		this.advertPackageId = advertPackageId;
	}


    public String getPeriodType() {
        return periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public Long getPeriodValue() {
        return periodValue;
    }

    public void setPeriodValue(Long periodValue) {
        this.periodValue = periodValue;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertPlanPeriodDto [advertId=");
        builder.append(advertId);
        builder.append(", startHour=");
        builder.append(startHour);
        builder.append(", endHour=");
        builder.append(endHour);
        builder.append(", launchLimit=");
        builder.append(launchLimit);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
