package cn.com.duiba.tuia.core.api.dto.req.account;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: AccountDetailQueryDto <br/>
 * Function: 账户查询条件. <br/>
 * date: 2018年4月2日 上午11:31:58 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AccountDetailQueryDto implements Serializable {

    private static final long serialVersionUID = -2791286943464732433L;

    /** id */
    private List<Long>        ids;

    /** 用户类型：0-广告主; 1-协作员; 2-代理商 */
    private Integer           userType;

    /** 用户类型：0-广告主; 1-协作员; 2-代理商 */
    private List<Integer>     userTypes;

    /** 代理商id */
    private Long              agentId;

    /** 代理商ids */
    private List<Long>        agentIds;

    /** 账户名称 */
    private String            companyName;

    /** 邮箱 */
    private String            email;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer           freezeStatus;

    /** 邮箱状态:0：未验证;1：已验证. */
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    private Integer           checkStatus;

    /** 代理商(广告主)等级 0为最顶级 */
    private Integer           accountLevel;

    /** 上级代理商层级连接，点分隔 */
    private String            accountLevelNum;

    /**
     * userTypes.
     *
     * @return the userTypes
     * @since JDK 1.8
     */
    public List<Integer> getUserTypes() {
        return userTypes;
    }

    /**
     * userTypes.
     *
     * @param userTypes the userTypes to set
     * @since JDK 1.8
     */
    public void setUserTypes(List<Integer> userTypes) {
        this.userTypes = userTypes;
    }

    /**
     * accountLevel.
     *
     * @return the accountLevel
     * @since JDK 1.8
     */
    public Integer getAccountLevel() {
        return accountLevel;
    }

    /**
     * accountLevel.
     *
     * @param accountLevel the accountLevel to set
     * @since JDK 1.8
     */
    public void setAccountLevel(Integer accountLevel) {
        this.accountLevel = accountLevel;
    }

    /**
     * freezeStatus.
     *
     * @return the freezeStatus
     * @since JDK 1.8
     */
    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    /**
     * freezeStatus.
     *
     * @param freezeStatus the freezeStatus to set
     * @since JDK 1.8
     */
    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    /**
     * emailStatus.
     *
     * @return the emailStatus
     * @since JDK 1.8
     */
    public Integer getEmailStatus() {
        return emailStatus;
    }

    /**
     * emailStatus.
     *
     * @param emailStatus the emailStatus to set
     * @since JDK 1.8
     */
    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.8
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.8
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * accountLevelNum.
     *
     * @return the accountLevelNum
     * @since JDK 1.8
     */
    public String getAccountLevelNum() {
        return accountLevelNum;
    }

    /**
     * accountLevelNum.
     *
     * @param accountLevelNum the accountLevelNum to set
     * @since JDK 1.8
     */
    public void setAccountLevelNum(String accountLevelNum) {
        this.accountLevelNum = accountLevelNum;
    }

    public AccountDetailQueryDto() {
        super();
    }

    public AccountDetailQueryDto(Integer userType) {
        super();
        this.userType = userType;
    }

    public AccountDetailQueryDto(Integer userType, List<Long> agentIds) {
        super();
        this.userType = userType;
        this.agentIds = agentIds;
    }

    public AccountDetailQueryDto(Integer userType, String accountLevelNum) {
        super();
        this.userType = userType;
        this.accountLevelNum = accountLevelNum;
    }

    /**
     * ids.
     *
     * @return the ids
     * @since JDK 1.8
     */
    public List<Long> getIds() {
        return ids;
    }

    /**
     * ids.
     *
     * @param ids the ids to set
     * @since JDK 1.8
     */
    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    /**
     * userType.
     *
     * @return the userType
     * @since JDK 1.8
     */
    public Integer getUserType() {
        return userType;
    }

    /**
     * userType.
     *
     * @param userType the userType to set
     * @since JDK 1.8
     */
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    /**
     * agentId.
     *
     * @return the agentId
     * @since JDK 1.8
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * agentId.
     *
     * @param agentId the agentId to set
     * @since JDK 1.8
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * agentIds.
     *
     * @return the agentIds
     * @since JDK 1.8
     */
    public List<Long> getAgentIds() {
        return agentIds;
    }

    /**
     * agentIds.
     *
     * @param agentIds the agentIds to set
     * @since JDK 1.8
     */
    public void setAgentIds(List<Long> agentIds) {
        this.agentIds = agentIds;
    }

    /**
     * companyName.
     *
     * @return the companyName
     * @since JDK 1.8
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * companyName.
     *
     * @param companyName the companyName to set
     * @since JDK 1.8
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * email.
     *
     * @return the email
     * @since JDK 1.8
     */
    public String getEmail() {
        return email;
    }

    /**
     * email.
     *
     * @param email the email to set
     * @since JDK 1.8
     */
    public void setEmail(String email) {
        this.email = email;
    }

}
