/**
 * Project Name:manager-domain<br>
 * File Name:AdvertStatisticsData.java<br>
 * Package Name:cn.com.duiba.tuia.manager.model<br>
 * Date:2016年5月24日下午2:10:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.data;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:AdvertStatisticsData <br/>
 * Function: 广告统计数据(发券量、曝光量、点击数、计费点击、点击UV、点击率、花费、点击均价). <br/>
 * Reason: . <br/>
 * Date: 2016年5月24日 下午2:10:36 <br/>
 * 
 */
public class AdvertStatisticsBaseDto extends BaseDto{

    /** serialVersionUID */
    private static final long serialVersionUID = 6979443723486903399L;

    /** 发券量. */
    private Long              launchCount;

    /** 曝光量. */
    private Long              exposureCount;

    /** 点击数. */
    private Long              clickCount;

    /** 有效点击. */
    private Long              efClickCount;

    /** 点击率. */
    private Float             clickRate;

    /** 花费. */
    private Long              consumeTotal;

    /** 点击均价. */
    private Integer           averagePrice;

    /** 点击UV. */
    private Long              clickUV;

    /** 结算状态. */
    private Integer           isSettlement;

    /** 人工计费单价. */
    private Long              billingPrice;

    /**
     * isSettlement.
     *
     * @return the isSettlement
     */
    public Integer getIsSettlement() {
        return isSettlement;
    }

    /**
     * isSettlement.
     *
     * @param isSettlement the isSettlement to set
     */
    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

    /**
     * billingPrice.
     *
     * @return the billingPrice
     */
    public Long getBillingPrice() {
        return billingPrice;
    }

    /**
     * billingPrice.
     *
     * @param billingPrice the billingPrice to set
     */
    public void setBillingPrice(Long billingPrice) {
        this.billingPrice = billingPrice;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public Float getClickRate() {
        return clickRate;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * averagePrice.
     *
     * @return the averagePrice
     * @since JDK 1.6
     */
    public Integer getAveragePrice() {
        return averagePrice;
    }

    /**
     * averagePrice.
     *
     * @param averagePrice the averagePrice to set
     * @since JDK 1.6
     */
    public void setAveragePrice(Integer averagePrice) {
        this.averagePrice = averagePrice;
    }

    /**
     * Gets the click uv.
     *
     * @return the click uv
     */
    public Long getClickUV() {
        return clickUV;
    }

    /**
     * Sets the click uv.
     *
     * @param clickUV the click uv
     */
    public void setClickUV(Long clickUV) {
        this.clickUV = clickUV;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
