package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.app.AppPackageSoltDetailDto;
import cn.com.duiba.tuia.core.api.dto.req.app.AppPkgSlotReq;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAppSlotDto;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/4/8
 * @function 广告位视图
 */
@AdvancedFeignClient
public interface RemoteAppPkgSlotService {

    /**
     * 获取流量包下的所有媒体的广告位
     */
    PageDto<AppPackageSoltDetailDto> getAppPkgSlots(AppPkgSlotReq appPkgSlotReq) throws BizException;

    /**
     * 查询需要添加广告位信息
     */
    List<RspAppSlotDto> getSlotDetailByIds(List<Long> slotIds) throws BizException;


    /**
     * 批量添加广告位
     */
    Boolean batchAddSlot(Long appPackageId,List<Long> allSlotIds) throws BizException;

    /**
     * 批量删除广告位
     */
    Boolean batchDeleteSlot(Long appPackageId,List<Long> allSlotIds) throws BizException;
}
