package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertOCPACostSuggestDto;

/**
 * ClassName: RemoteAdvertOCPAConvertSuggestService <br/>
 * Function: 广告对应的出价建议. <br/>
 * date: 2019年1月24日 下午7:08:00 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteAdvertOCPACostSuggestService {

    /**
     * selectAdvertOCPAConvertSuggest:(查询广告对应的出价建议). <br/>
     *
     * @param advertId the advert id
     * @return the list< advert ocpa cost suggest d o>
     * @author chencheng
     * @since JDK 1.8
     */
    List<AdvertOCPACostSuggestDto> selectAdvertOCPACostSuggest(Long advertId);
}
