package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertTargetAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/29 13:48
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertTargetAppService {

    /**
     * 通过广告ID查询关联的定向媒体App.
     *
     * @param advertId    the advert id
     * @param orientPkgId
     * @return the list< long>
     */
    DubboResult<AdvertTargetAppDto> selectAppByAdvertId(Long advertId, Long orientPkgId);

    /**
     * 查询广告的定向媒体列表
     *
     * @param advertId 广告ID
     * @return
     */
    List<Long> selectAdvertTargetAppIds(Long advertId);

    List<Long> selectOrientationTargetPackageIds(Long orientationId);

    /**
     * 更新该广告绑定的app.
     *
     * @param req the req
     * @return the int
     */
    DubboResult<Integer> updateBindApp(AdvertTargetAppDto req);

    /**
     * 如果该广告没有关联定向媒体,则插入一条记录.
     *
     * @param req the req
     */
    DubboResult<Integer> insert(AdvertTargetAppDto req);
    
    /**
     * 根据定向配置ID获取定向媒体
     * 
     * @param advertIds
     * @return
     */
    List<AdvertTargetAppDto> listAdvertTargetAppByAdvertId(List<Long> advertIds);


}
