/**
 * 文件名： LoginVO.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月30日 下午3:20:05
 */
package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseAccountDto;

/**
 * 登录成功后返回的信息.
 *
 * @author: leiliang
 * @version:
 */
public class RspTuiaLogin implements Serializable {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long    serialVersionUID = 286099162710547519L;

    /** 广告主列表. */
    private List<BaseAccountDto> advertisers;

    /** 加密秘钥. */
    private String               sign;

    /** 时间戳. */
    private long                 tamp;

    /** 登录的用户ID. */
    private Long                 userId;

    /** 用户类型. */
    private Integer              userType;

    /** 登录结果(true：成功， false：失败). */
    private boolean              loginResult;

    /** 协作员绑定的(唯一一个)广告主id. */
    private Long                 advertiserId;

    /** 当前登录用户角色id. */
    private Long                 rid;

    /** 代理商ID. */
    private Long                 agentId;

    /** 代理商名称. */
    private String               agentName;

    /**
     * The Constructor.
     */
    public RspTuiaLogin() {
        super();
    }

    /**
     * The Constructor.
     *
     * @param userId the user id
     * @param userType the user type
     * @param advertiserId the advertiser id
     * @param loginResult the login result
     * @param agentName the agent name
     */
    public RspTuiaLogin(Long userId, Integer userType, Long advertiserId, boolean loginResult, String agentName) {
        this.userId = userId;
        this.userType = userType;
        this.advertiserId = advertiserId;
        this.loginResult = loginResult;
        this.agentName = agentName;
    }

    /**
     * The Constructor.
     *
     * @param userId the user id
     * @param userType the user type
     * @param advertiserId the advertiser id
     * @param loginResult the login result
     * @param rid the rid
     * @param agentId the agent id
     * @param agentName the agent name
     */
    public RspTuiaLogin(Long userId, Integer userType, Long advertiserId, boolean loginResult, Long rid, Long agentId,
                        String agentName) {
        this.userId = userId;
        this.userType = userType;
        this.advertiserId = advertiserId;
        this.loginResult = loginResult;
        this.rid = rid;
        this.agentId = agentId;
        this.agentName = agentName;
    }

    /**
     * agentName.
     *
     * @return the agentName
     * @since JDK 1.6
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * agentName.
     *
     * @param agentName the agentName to set
     * @since JDK 1.6
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    /**
     * Gets the agent id.
     *
     * @return the agent id
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * Sets the agent id.
     *
     * @param agentId the agent id
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * Gets the rid.
     *
     * @return the rid
     */
    public Long getRid() {
        return rid;
    }

    /**
     * Sets the rid.
     *
     * @param rid the rid
     */
    public void setRid(Long rid) {
        this.rid = rid;
    }

    /**
     * Gets the advertiser id.
     *
     * @return the advertiser id
     */
    public Long getAdvertiserId() {
        return advertiserId;
    }

    /**
     * Sets the advertiser id.
     *
     * @param advertiserId the advertiser id
     */
    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    /**
     * Gets the user id.
     *
     * @return the user id
     */
    public Long getUserId() {
        return userId;
    }

    /**
     * Sets the user id.
     *
     * @param userId the user id
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * Gets the user type.
     *
     * @return the user type
     */
    public Integer getUserType() {
        return userType;
    }

    /**
     * Sets the user type.
     *
     * @param userType the user type
     */
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    /**
     * Checks if is login result.
     *
     * @return true, if checks if is login result
     */
    public boolean isLoginResult() {
        return loginResult;
    }

    /**
     * Sets the login result.
     *
     * @param loginResult the login result
     */
    public void setLoginResult(boolean loginResult) {
        this.loginResult = loginResult;
    }

    /**
     * Gets the advertisers.
     *
     * @return the advertisers
     */
    public List<BaseAccountDto> getAdvertisers() {
        return advertisers;
    }

    /**
     * Sets the advertisers.
     *
     * @param advertisers the advertisers
     */
    public void setAdvertisers(List<BaseAccountDto> advertisers) {
        this.advertisers = advertisers;
    }

    /**
     * Gets the sign.
     *
     * @return the sign
     */
    public String getSign() {
        return sign;
    }

    /**
     * Sets the sign.
     *
     * @param sign the sign
     */
    public void setSign(String sign) {
        this.sign = sign;
    }

    /**
     * Gets the tamp.
     *
     * @return the tamp
     */
    public long getTamp() {
        return tamp;
    }

    /**
     * Sets the tamp.
     *
     * @param tamp the tamp
     */
    public void setTamp(long tamp) {
        this.tamp = tamp;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
