package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.OligrachTradeDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.OligrachAdvertiserDto;
import cn.com.duiba.tuia.core.api.dto.rsp.AdvertOligrachTradeDto;

import java.util.List;

/**
 * Created by huangch on 2018/8/7 14:14
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteOligrachTradeService {

    /**
     * 查询新的综合行业标签列表
     */
    List<String> getNewTradeList();

    /**
     * 通过主键查询寡头行业
     *
     * @param id 寡头行业表查询的主键ID
     */
    AdvertOligrachTradeDto selectOligrachTradeById(Long id);

    /**
     * 通过行业名称查询添加的寡头行业数据
     */
    AdvertOligrachTradeDto selectByNewTrade(String newTradeName);

    /**
     * 添加寡头行业
     *
     * @param newTradeName 添加的新综合行业名称
     * @param expectKaNum  期望的KA数量
     */
    Boolean addNewTrade(String newTradeName, Integer expectKaNum) throws BizException;

    /**
     * 添加寡头行业下的寡头广告主
     *
     * @param advertiserIds 添加的广告主账号ID列表
     * @param id            查询寡头行业列表返回的主键ID
     */
    Boolean addAdvertiser(List<Long> advertiserIds, Long id);

    /**
     * 编辑KA数量
     *
     * @param expectKaNum 期望的KA个数
     * @param id          列表主键ID
     */
    Boolean editKaNum(Integer expectKaNum, Long id);

    /**
     * 删除寡头行业
     *
     * @param id 列表主键ID
     */
    Boolean deleteOligrachTrade(Long id);

    /**
     * 删除寡头行业下的寡头广告主
     *
     * @param id           列表主键ID
     * @param advertiserId 删除的寡头广告主账号ID
     */
    Boolean deleteOligrachAdvertiser(Long id, Long advertiserId);

    /**
     * 查询广告主列表
     *
     * @param advertiserIds 广告主IDS
     */
    List<OligrachAdvertiserDto> queryAdvertiserList(List<Long> advertiserIds);

    /**
     * 分页查询寡头行业列表
     *
     * @param advertiserIds 查询的广告主ID列表
     * @param newTradeName  新行业名称
     * @param currentPage   当前页
     * @param pageSize      页大小
     */
    PageDto<OligrachTradeDto> queryPageList(List<Long> advertiserIds, String newTradeName, int currentPage, int pageSize);

}
