package cn.com.duiba.tuia.core.api.remoteservice.orientPkg;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.orientPkg.OrientPkgExpandReq;
import cn.com.duiba.tuia.core.api.dto.rsp.orientPkg.OrientPkgExpandDto;

/**
 * 
 * ClassName: RemoteOrientPkgExpandService <br/>
 * Function: 定向配置拓展信息. <br/>
 * date: 2019年5月17日 下午3:54:52 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteOrientPkgExpandService {

    /**
     * 
     * selectByOrientId:(根据配置id查询配置拓展信息). <br/>
     *
     * @author chencheng
     * @param orientId
     * @return
     * @since JDK 1.8
     */
    OrientPkgExpandDto selectByOrientId(Long orientId);
    
    /**
     * 
     * selectByEntity:(批量查询配置拓展新增). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<OrientPkgExpandDto> selectByEntity(OrientPkgExpandReq query);
    
    /**
     * 
     * addOrientPkgExpand:(新增配置拓展). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int addOrientPkgExpand(OrientPkgExpandDto dto);
    
    /**
     * 
     * updateOrientPkgExpand:(修改配置拓展). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int updateOrientPkgExpand(OrientPkgExpandDto dto); 
    
}

