package cn.com.duiba.tuia.core.api.remoteservice.promotetest;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PromoteTestAuditQueryDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPromoteTestAuditQuery;
import cn.com.duiba.tuia.core.api.dto.rsp.promotetest.AdvertPromoteTestDto;
import cn.com.duiba.tuia.core.api.dto.statistics.AdvertMaterialPromoteStatisticDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**测试落地页远程服务提供
 * Created by jzl on 18/5/14.
 */
@AdvancedFeignClient
public interface RemotePromoteTestService {

    /**
     * 查询测试落地页集合,该接口只查询A/B TEST的落地页测试链接，即url_type=0的数据
     * @param advertId
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListByAdvertId(Long advertId);

    /**
     * 查询测试落地页集合,带已删除的数据
     * @param advertId
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListWithDeletedByAdvertId(Long advertId);

    /**
     * 活动是否配置了广告落地页弹层测试
     * @return
     */
    Boolean isConfigLayerTest(Long advertId);

    /**
     * 新增或修改
     * @param advertPromoteTestDto
     * @return
     */
    Integer addOrUpdatePromoteTestUrl(AdvertPromoteTestDto advertPromoteTestDto);

    /**
     * 删除广告下的全部测试落地页，及关联的素材
     * @param advertId
     * @return
     */
    Integer deleteAllByAdvertId(Long advertId);

    Integer updatePromoteTestUrlById(AdvertPromoteTestDto advertPromoteTestDto);

    AdvertPromoteTestDto selectById(Long id);

    Integer addPromoteTestUrl(AdvertPromoteTestDto advertPromoteTestDto);

    /**
     * 查询广告新媒体推广链接，一个广告志辉有一个生效的
     *
     * @param advertId 广告ID
     * @param status   审核状态，可以为空
     * @return
     */
    AdvertPromoteTestDto queryAdvertNewAppPromoteTest(Long advertId, Integer status);

    /**
     * 删除单个测试落地页，及关联的素材
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 分页查询测试落地页
     * @param req
     * @return
     */
    List<PromoteTestAuditQueryDto> findPromoteTestAuditQuery(ReqPromoteTestAuditQuery req);

    /**
     * 查询数量
     * @param req
     * @return
     */
    Integer findPromoteTestAuditQueryCount(ReqPromoteTestAuditQuery req);

    /**
     * 审核
     * @param id
     * @param auditResult 1通过 2拒绝
     * @param materialIds
     * @param rejectReason
     * @return
     */
    Integer auditPassOrReject(Long id, Integer auditResult, List<Long> materialIds, String rejectReason, String auditor);

    /**
     * 查询审核通过的测试落地页,只查询A/B TEST的测试链接，即url_type=0
     * @param advertId
     * @param status
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListByAdvertIdAndStatus(Long advertId, Integer status);

    /**
     * 素材审核选择落地页提交接口
     * @param id
     * @param materialId
     * @return
     */
    Integer materialPromoteAudit(Long id, Long materialId);

    /**
     * 查询广告－落地页回流统计数据
     * @param advertId
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticData(Long advertId, Date startDate, Date endDate);

    /**
     * 查询广告－落地页回流统计数据
     * @param advertId
     * @param startDate
     * @param endDate
     * @param exportType
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataForExport(Long advertId, Date startDate, Date endDate, Integer exportType);

    /**
     * 查询素材－广告－落地页回流统计数据
     * @param advertId
     * @param materialId
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findMaterialAdvertPromoteStatisticData(Long advertId, Long materialId, Date startDate, Date endDate);

    /**
     * 查询素材－广告－落地页回流统计数据
     * @param advertId
     * @param materialId
     * @param startDate
     * @param endDate
     * @param exportType
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findMaterialAdvertPromoteStatisticDataForExport(Long advertId, Long materialId, Date startDate, Date endDate, Integer exportType);

    /**
     * 查询素材的所有url的统计数据
     * @param advertIds
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findMaterialAdvertPromoteStatisticDataByMaterial(List<Long> advertIds,Integer exportType, Date startDate, Date endDate);

    /**
     * 根据advertId查询素材ID集合
     * @param advertId
     * @return
     */
    List<Long> findMaterialIdsByAdvertId(Long advertId);

    /**
     * 根据Id查询素材ID集合
     * @param id
     * @return
     */
    List<Long> findMaterialIdsById(Long id);


    /**
     * 广告——落地页按 advertIds统计
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataByAdvertIds(List<Long> advertIds, Date startDate, Date endDate);

    /**
     * 广告——落地页按 advertIds统计 分组条件 advert_id , promote_url  cur_date
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataByAdvertIdsGroupByCurDate(List<Long> advertIds, Date startDate, Date endDate) ;
    /**
     * 
     * handleUrlsMD5ToPromoteUrl:(获取加密落地页链接对应的原始链接). <br/>
     *
     * @author chencheng
     * @param urlsMd5
     * @return
     * @since JDK 1.8
     */
    Map<String, String> handleUrlsMD5ToPromoteUrl(List<String> urlsMd5);
}
