package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.OrientationFocusAppConvertCostDto;
import cn.com.duiba.tuia.core.api.dto.req.FocusAppDataReqDto;
import cn.com.duiba.tuia.core.api.dto.statistics.FocusAppDataEntityDto;

import java.util.List;

/**
 * Created by huangch on 2019/1/29 15:26
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteOrientationFocusAppDataService {


    /**
     * 查询重点媒体汇总数据
     *
     * @return 配置汇总数据
     */
    FocusAppDataEntityDto queryFocusAppSummaryData(FocusAppDataReqDto reqDto);

    /**
     * 分页查询重点媒体数据
     *
     * @return
     */
    PageDto<FocusAppDataEntityDto> pageQueryFocusAppData(FocusAppDataReqDto reqDto);

    /**
     * 批量插入重点媒体转化出价
     */
    Integer batchInsertFocusAppConvertCost(List<OrientationFocusAppConvertCostDto> list);

    /**
     * 批量更新媒体转化出价
     *
     * @param list 更新列表 传入ID和convertCost
     * @return
     */
    Integer batchUpdateFocusAppConvertCost(List<OrientationFocusAppConvertCostDto> list);

    /**
     * 查询广告配置的重点媒体转化出价列表
     *
     * @param orientationId 配置ID
     * @param subtype       转化类型
     * @return
     */
    List<OrientationFocusAppConvertCostDto> selectOrientationFocusAppConvertCost(Long orientationId, Integer subtype);
    
    /**
     * 
     * selectByOrientationIdAndSubtype:(根据配置ID，优化目标，包的类型，计费方式， 投放目标类型，是否开启潜力广告扶持，查询已保存的分媒体出价). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<OrientationFocusAppConvertCostDto> selectByOrientationIdAndSubtype(OrientationFocusAppConvertCostDto query);

    /**
     * 
     * deleteAdvertOrientPkgDisAppFee:(根据配置ID，优化目标，包的类型，计费方式， 投放目标类型，是否开启潜力广告扶持，删除分媒体出价). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    Integer deleteAdvertOrientPkgDisAppFee(OrientationFocusAppConvertCostDto query);
    
    /**
     * 
     * deleteById:(根据id删除). <br/>
     *
     * @author chencheng
     * @param ids
     * @return
     * @since JDK 1.8
     */
    Integer deleteById(List<Long> ids);

    /**
     * 
     * batchReplace:(分媒体出价，对唯一键数据新增或修改). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchReplace(List<OrientationFocusAppConvertCostDto> list);

    /**
     * 删除媒体通过广告和配置id
     */
    Integer deleteByAdvertId(Long advertId,Long orientPkgId);
}
