package cn.com.duiba.tuia.core.api.dto.companydynamic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: CompanyDynamicReq
 * Function: 公司动态请求实体
 * Date:     2019/5/17 0017 上午 9:51
 */
@ApiModel("公司动态请求实体")
public class CompanyDynamicDto implements Serializable {


    private static final long serialVersionUID = 2817220869529940805L;

    @ApiModelProperty(value = "动态信息的ID")
    private Long id;

    @ApiModelProperty(value = "主题")
    @NotNull
    private String topic;

    @ApiModelProperty("新闻来源")
    @NotNull
    private String newsFrom;

    @ApiModelProperty("新闻来源链接")
    @NotNull
    private String newsFromLink;

    @ApiModelProperty("日期 yyyy-MM-dd")
    @NotNull
    private String date;

    @ApiModelProperty("摘要描述")
    @NotNull
    private String abstractDesc;

    @ApiModelProperty("正文描述")
    @NotNull
    private String context;

    @ApiModelProperty("是否发布 0 表示保存 1表示保存并发布")
    @NotNull
    private Integer isPush;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getNewsFrom() {
        return newsFrom;
    }

    public void setNewsFrom(String newsFrom) {
        this.newsFrom = newsFrom;
    }

    public String getNewsFromLink() {
        return newsFromLink;
    }

    public void setNewsFromLink(String newsFromLink) {
        this.newsFromLink = newsFromLink;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getAbstractDesc() {
        return abstractDesc;
    }

    public void setAbstractDesc(String abstractDesc) {
        this.abstractDesc = abstractDesc;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Integer getIsPush() {
        return isPush;
    }

    public void setIsPush(Integer isPush) {
        this.isPush = isPush;
    }
}
