/**
 * 文件名： UpdateAdvertPlanReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月12日 上午10:14:13
 */
package cn.com.duiba.tuia.core.api.dto.req;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.AdvertPlanPeriodDto;

/**
 * 修改广告计划请求参数.
 *
 * @author: leiliang
 * @version:
 */
public class ReqUpdateAdvertPlanDto implements Serializable{
    
    private static final long serialVersionUID = 1L;

    /** 投放端调用. */
    public static final int CALL_TYPE_OF_TUIA = 0;
    
    /** 管理端调用. */
    public static final int CALL_TYPE_OF_MANAGER = 1;

    /** 广告主ID. */
    private Long                      advertiserId;

    /** 广告ID. */
    private Long                      advertId;

    /** 名称. */
    private String                    name;

    /** 计费方式. */
    private Integer                   chargeType;

    /** 广告出价. */
    private Long                      fee;

    /** 每日预算. */
    private Long                      budgetPerDay;

    /** 生效期. */
    private String                    startDate;

    /** 失效期. */
    private String                    endDate;

    /** 投放Id列表. */
    private String                    regionIds;

    /** 投放平台. */
    private List<String>              platform;

    /** 投放时段. */
    private List<AdvertPlanPeriodDto> periods;

    /** 调用端：(0：投放端，1：管理端). */
    private int                       callType;

    public int getCallType() {
        return callType;
    }

    public void setCallType(int callType) {
        this.callType = callType;
    }

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(String regionIds) {
        this.regionIds = regionIds;
    }

    public List<String> getPlatform() {
        return platform;
    }

    public void setPlatform(List<String> platform) {
        this.platform = platform;
    }

    public List<AdvertPlanPeriodDto> getPeriods() {
        return periods;
    }

    public void setPeriods(List<AdvertPlanPeriodDto> periods) {
        this.periods = periods;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
