package cn.com.duiba.tuia.core.api.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.joda.time.DateTime;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2017/12/15 18:03
 * description:
 *
 * @since JDK 1.6
 */
public class TimeUtil {

    private static final List<String> weeks = Lists.newArrayList("周一", "周二", "周三", "周四", "周五", "周六", "周日");

    /**
     * 获取当前日期的周数
     *
     * @return 周数
     */
    public static String getWeek() {
        return weeks.get(Calendar.getInstance().get(Calendar.DAY_OF_WEEK) - 2);
    }

    public static List<Integer> getMonthBetween(Date minDate, Date maxDate) {
        List<Integer> result = Lists.newArrayList();

        DateTime maxDateTime = new DateTime(maxDate);
        DateTime curDateTime = new DateTime(minDate);

        //防止死循环
        int maxForEachCount = 0;

        while (curDateTime.compareTo(maxDateTime) < 0 && maxForEachCount < 100) {
            result.add(curDateTime.getMonthOfYear());
            curDateTime = curDateTime.plusMonths(1);
            maxForEachCount++;
        }

        return result;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(getMonthBetween(DateTime.parse("2017-07-01").toDate(), DateTime.parse("2018-03-01").toDate())));
    }
}
