package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.List;

/**
 * Created by huangch on 2018/8/2 14:51
 * description:
 *
 * @since JDK 1.6
 */
public class TagAdvertInfoDto implements Serializable {

    private static final long serialVersionUID = -1952845479322254984L;
    //广告ID
    private Long advertId;

    //广告行业标签
    private String tagNum;

    //广告类型,1-互动广告、2-展示广告
    private Integer advertType;

    //广告名称
    private String advertName;

    private List<MediaMaterialDto> materialList;

    //广告状态 详细见：cn.com.duiba.tuia.core.api.enums.advert.AdvertValidStatusEnum
    private Integer advertStatus;

    //广告状态描述
    private String advertStatusDesc;

    //广告素材图片链接，请使用materialList列表下的链接
    @Deprecated
    private List<String> materialUrls;

    //广告推广链接地址
    private List<String> promotionUrls;

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public String getTagNum() {
        return tagNum;
    }

    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    public List<MediaMaterialDto> getMaterialList() {
        return materialList;
    }

    public void setMaterialList(List<MediaMaterialDto> materialList) {
        this.materialList = materialList;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Integer getAdvertStatus() {
        return advertStatus;
    }

    public void setAdvertStatus(Integer advertStatus) {
        this.advertStatus = advertStatus;
    }

    public String getAdvertStatusDesc() {
        return advertStatusDesc;
    }

    public void setAdvertStatusDesc(String advertStatusDesc) {
        this.advertStatusDesc = advertStatusDesc;
    }

    public List<String> getMaterialUrls() {
        return materialUrls;
    }

    public void setMaterialUrls(List<String> materialUrls) {
        this.materialUrls = materialUrls;
    }

    public List<String> getPromotionUrls() {
        return promotionUrls;
    }

    public void setPromotionUrls(List<String> promotionUrls) {
        this.promotionUrls = promotionUrls;
    }

    @Override
    public String toString() {
        return "TagAdvertInfoDto{" +
                "advertId=" + advertId +
                ", tagNum='" + tagNum + '\'' +
                ", advertType=" + advertType +
                ", advertName='" + advertName + '\'' +
                ", materialList=" + materialList +
                ", advertStatus=" + advertStatus +
                ", advertStatusDesc='" + advertStatusDesc + '\'' +
                ", materialUrls=" + materialUrls +
                ", promotionUrls=" + promotionUrls +
                '}';
    }
}
