
/**
 * Project Name:tuia-core-api<br>
 * File Name:MaterialListCahce.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp<br>
 * Date:2016年12月26日上午9:36:16<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 *
 */

package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * ClassName: MaterialListCahce <br/>
 * Function: 素材返回结果. <br/>
 * date: 2016年12月26日 上午9:36:16 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public class RspMaterialList implements Serializable {

    /**
     * @since JDK 1.7
     */
    private static final long serialVersionUID = 5157076919587057188L;

    /** 老素材列表. */
    private List<Long> oldMaterials;
    
    /** 新素材列表. */
    private List<Long> newMaterials;
    
    /** 老素材流量占比. */
    private Long oldMaterialTraffic;
    
    /** 新素材流量占比 **/
    private Long oldMaterialRatio;

    
    public List<Long> getOldMaterials() {
        return oldMaterials;
    }

    
    public void setOldMaterials(List<Long> oldMaterials) {
        this.oldMaterials = oldMaterials;
    }

    
    public List<Long> getNewMaterials() {
        return newMaterials;
    }

    
    public void setNewMaterials(List<Long> newMaterials) {
        this.newMaterials = newMaterials;
    }

    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }


    
    public Long getOldMaterialTraffic() {
        return oldMaterialTraffic;
    }


    
    public void setOldMaterialTraffic(Long oldMaterialTraffic) {
        this.oldMaterialTraffic = oldMaterialTraffic;
    }


    
    public Long getOldMaterialRatio() {
        return oldMaterialRatio;
    }


    
    public void setOldMaterialRatio(Long oldMaterialRatio) {
        this.oldMaterialRatio = oldMaterialRatio;
    }

}

