/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertMaterialBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年12月21日下午4:22:28<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.ImageDto;
import cn.com.duiba.tuia.core.api.dto.MaterialCheckRecordDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.material.AuditAdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.material.ReqMaterialAuditQueryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * ClassName: RemoteAdvertMaterialBackendService <br/>
 * date: 2016年12月21日 下午4:22:28 <br/>
 * .
 *
 * @author youhaijun
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteAdvertMaterialBackendService {

    /**
     * 新增一个素材.
     *
     * @param dto the dto
     * @return the dubbo result< Long>
     */
    DubboResult<Long> createMaterial(AdvertMaterialDto dto);

    /**
     * 批量新增素材
     *
     * @param materialList 素材列表
     */
    Integer batchCreateMaterial(List<AdvertMaterialDto> materialList);

    /**
     * 代理商平台更新展示广告素材信息
     */
    Boolean updateWebShowAdvertMaterial(List<ImageDto> reqList);

    /**
     * 隐藏素材
     * @param id 素材ID
     */
    Boolean hiddenMaterial(Long id, Integer hiddenStatus);

    /**
     * 管理后台新增和修改展示广告素材
     */
    Boolean updateManagerShowAdvertMaterial(ImageDto req) throws BizException;

    /**
     * 更新一个素材.
     *
     * @param dto the dto
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateMaterial(AdvertMaterialDto dto);

    /**
     * 更新素材激活/屏蔽状态.
     *
     * @param id            the id
     * @param status        the status
     * @param everActivated the ever activated
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateActiveStatus(Long id, Integer status, Integer everActivated,Integer isManual);

    /**
     * 更新素材名称.
     *
     * @param advertId     the id
     * @param materialName the materialName
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateMaterialName(Long advertId, String materialName);

    /**
     * 根据广告ID查询当前广告拥有的激活素材数量.
     *
     * @param advertId the advert id
     * @return the dubbo result< integer>
     */
    DubboResult<Integer> queryActivatedMaterialCount(Long advertId);

    /**
     * 根据广告ID查询当前广告拥有的未删除素材列表.
     *
     * @param advertId the advert id
     * @return the dubbo result< list< advert material dto>>
     */
    DubboResult<List<AdvertMaterialDto>> queryMaterialList(Long advertId);

    /**
     * 根据素材id查找单个素材
     *
     * @param id 素材id
     * @return 单个素材
     */
    DubboResult<AdvertMaterialDto> getMaterialById(Long id);

    /**
     * 根据广告id列表查找多个素材
     *
     * @param advertIds 广告id列表
     * @return 有效素材列表
     */
    DubboResult<List<AdvertMaterialDto>> getMaterialByAdvertIds(List<Long> advertIds);

    /**
     * 查询广告的默认素材
     */
    List<AdvertMaterialDto> selectDefaultByAdvertIds(List<Long> advertIds);

    /**
     * 根据多个广告id查询可用的素材列表
     * @param advertIds 广告id列表
     * @return 可用素材列表
     */
    DubboResult<List<AdvertMaterialDto>> getAvailableMaterialsByAdvertIds(List<Long> advertIds);

    /**
     * 获取默认素材ID
     * 请使用cn.com.duiba.tuia.core.api.remoteservice.RemoteAdvertMaterialBackendService#getDefaultMaterialIds(java.lang.Long)
     * @param advertId 广告id
     * @return
     */
    @Deprecated
    DubboResult<Long> getDefaultMaterialId(Long advertId);

    List<Long> getDefaultMaterialIds(Long advertId);

    /**
     * 审核拒绝
     *
     * @param id 素材id
     * @return 拒绝结果
     */
    DubboResult<Boolean> auditRefuse(Long id,String reason);

    /**
     * 审核通过
     *
     * @param id 素材id
     * @param id 素材标签
     * @return 通过结果
     */
    DubboResult<Boolean> auditPass(Long id, String materialTags);

    DubboResult<Boolean> auditCommit(Long id);

    DubboResult<PageDto<AdvertMaterialDto>> listByIds(ReqMaterialAuditQueryDto queryDto);

    DubboResult<List<Long>> getNotDefaultMaterialIdsByAdvertIds(List<Long> advertIds);

    DubboResult<List<Long>> getMaterialIdsByCouponName(String couponName);

    DubboResult<List<Long>> getAllIdsExceptDefault();

    DubboResult<List<Long>> getMaterialIdsByName(String materialName);

    DubboResult<Map<Long, String>> getRefuseReasonByIds(List<Long> ids, Integer materialType);

    /**
     * 
     * getMaterialListByIds:(根据素材id集合查询素材). <br/>
     *
     * @author chencheng
     * @param materialIds
     * @return
     * @since JDK 1.8
     */
    DubboResult<List<AdvertMaterialDto>> getMaterialListByIds(List<Long> materialIds);

    /**
     * 获取广告的有效素材列表
     * @param advertId
     * @return
     */
    DubboResult<List<AdvertMaterialDto>> getValidMaterialsByAdvertId(Long advertId);

    List<AdvertMaterialDto> queryByDesigner(String designer);

    Boolean auditAdvertMaterial (AuditAdvertMaterialDto dto);

    /**
     * 管理后台批量新增展示广告素材
     */
    Boolean updateAddShowAdvertMaterial(List<ImageDto> imageDtos) throws BizException;

    /**
     * 根据素材id 查询审核记录信息
     */
    List<MaterialCheckRecordDto> getCheckRecordByMaterialId(Long materialId, Integer materialType);

    /**
     * 根据广告id 和 material
     * @param advertIds
     * @param materialName
     * @return
     */
    List<AdvertMaterialDto> getMaterialsByAdvertIdsAndMaterialName(List<Long> advertIds,String materialName);
}
