package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertTradePackageDto;

import java.util.List;
import java.util.Map;

/**
 * @author zhangmeng
 * @date 2018/12/2
 * @function
 */
@AdvancedFeignClient
public interface RemoteAdvertTradePackageService {

    /**
     * 查询所有有效的人群定向行业人群包标签
     * @return
     */
    List<AdvertTradePackageDto> queryTradePackageTag();

    /**
     * 保存行业人群定向包行业人群包标签（新增和修改后的保存）如果有标签值或这value存在则不允许插入或者修改
     * @param advertTradePackageDto
     * @return id
     */
     Long saveTradePackageTag(AdvertTradePackageDto advertTradePackageDto);


    /**
     * 删除指定的人群定向包行业人群包标签(需要校验当前标签是否存在被配置引用，引用则提示不允许删除)
     * @param id
     * @return
     */
    int deleteTradePackageTag(Long id);

    /**
     * 校验行业人群包标签是否已经存在
     * @return
     */
    Boolean checkTagIsExisted(AdvertTradePackageDto advertTradePackageDto);

    /**
     * 校验行业人群包标签是否被配置引用
     * @return
     */
    Boolean checkTagIsUsed(String tagVlaue);

    /**
     * 根据标签 查询 定向人群包类型（OrientPeopleTagTypeEnum）
     * key-> tagId
     */
    Map<String, String> queryOrientPeoplePackagTypesByTagValues(List<Long> tagIds);

    /**
     * 根据 标签 删除定向人群包
     */
    Boolean deleteTradePackageTagByTagValue(String tagValue);

    /**
     * 根据 标签 查询所有的定向人群包（因为是软删除除，所以包含未删除的）
     */
    AdvertTradePackageDto queryAllTradePackageTagByTagValue(String tagValue);

    /**
     * 更新行业人群包（标签中文名 和 类型）
     */
    Boolean updateTradePackageTag(AdvertTradePackageDto updateDto);

    /**
     * 根据定向人群包 类型查询 人群包
     * @param type
     * @return
     */
    List<AdvertTradePackageDto> queryTradePackageTagByType(String type);

    /**
     * 根据定向人群包 类型查询 人群包（已经删除的，并且按 tagValue 去重复（按时间倒序取第一条））
     * @param type
     * @return
     */
    Map<String,AdvertTradePackageDto> queryRecentlyDeleteTradePackageTagByType(String type);



}
