package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 用于更新落地页地址后，操作屏蔽流量
 * 2018-05-09
 * zhangmeng
 */
@AdvancedFeignClient
public interface RemoteAdvertUpdateCouponService {
    /**
     * 通过落地页地址，来进行屏蔽流量操作
     * @param promoteUrl
     */
    void updateCoupon(Long advertId,String promoteUrl);

    /**
     * 通过定向配置id巡查
     * @param orientationId
     * @param promoteUrl
     */
    void updateCouponByOrientationId(Long orientationId,String promoteUrl);

    /**
     * 将微信屏蔽的落地页地址插入到“微信屏蔽列表”中
     */
    void insertForbidUrl(Long advertId,String Url);

    /**
     * 修改定向配置包中的 app安装 是否对流量屏蔽生效
     */
    void updateIsAppInstall(Long advertId,Integer isAppInstall,Long orientPkgId);

    /**
     * 更新tb_shield_domain_record表中的url_domain
     */
    void updateUrlDomain();

    /**
     * 修复误插入的微信屏蔽url,同时去掉被勾中的微信屏蔽标签
     */
    void batchUpdateWeChatForbid(List<Long> ids,String url);
}
