package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.EncourageMaterialDto;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteEncourageMaterialService
 * Function: 激励广告相关 素材远程服务
 * Date:     2019/5/30 0030 下午 3:20
 */
@AdvancedFeignClient
public interface RemoteEncourageMaterialService {

    List<EncourageMaterialDto> getEncourageMaterialByAdveertId(Long advertId);

    Integer updateEncourageMaterial(EncourageMaterialDto req);

    /**
     * 根据广告集合和默认状态批量查询弹层
     * @param advertIds
     * @param isDefault
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByList(List<Long> advertIds, Integer isDefault);

    /**
     * 根据弹层id获取数据
     * @param windIds
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByWinId(List<Long> windIds);

    /**
     * 根据条件查询数据
     * @param materialDto
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByMaterial(EncourageMaterialDto materialDto);
}
