package cn.com.duiba.tuia.core.api.remoteservice.risk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advertiser.AdvertiserSimpleDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertBaseInfoDto;
import cn.com.duiba.tuia.core.api.dto.risk.SlotDirectionDto;
import cn.com.duiba.tuia.core.api.dto.risk.TagBaseDto;
import cn.com.duiba.tuia.core.api.dto.risk.TagsItemDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotWhiteListDto;

import java.util.List;
import java.util.Map;

/**
 * Created by huangch on 2018/4/26 14:03
 * description: 给风控(钟馗)提供需要的接口
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteRiskControlService {

    /**
     * 查询所有的广告行业标签(一级行业标签)
     *
     * @return tagNum&tagName
     */
    List<TagBaseDto> queryAdvertIndustryTagList();

    /**
     * 查询所有的广告落地页标签(二级标签)
     *
     * @return tagNum&tagName
     */
    List<TagBaseDto> queryAdvertLandPageTagList();

    /**
     * 广告复审结果处理
     *
     * @param advertIds        复审的广告id集合——必传
     * @param reviewResultType 复审结果类型，1-复审通过，2-复审拒绝——必传
     * @param refuseReason     复审时的拒绝原因——reviewResultType=2时必传
     * @return 处理成功or失败
     */
    Boolean advertReviewResultHandle(List<Long> advertIds, Integer reviewResultType, String refuseReason);

    /**
     * 广告巡检结果处理
     *
     * @param advertIds         巡检的广告id集合——必传
     * @param inspectResultType 巡检结果类型，1-巡检通过，2-巡检拒绝，3-巡检下线——必传
     * @param refuseReason      巡检时的拒绝原因——inspectResultType=2时必传
     * @return 处理成功or失败
     */
    Boolean advertInspectResultHandle(List<Long> advertIds, Integer inspectResultType, String refuseReason);

    /**
     * 通过广告id，查询对应的行业，落地页，属性，
     */
    Map<Long,List<TagsItemDto>> getTagsByAdvertId(List<Long> ids);

    /**
     * 查询广告失效状态
     *
     * @param advertIds 查询广告ID
     * @return Map<广告ID,广告状态:1-失效 0-未失效>
     */
    Map<Long, Integer> queryAdvertAbateStatus(List<Long> advertIds);

    /**
     * 查询落地页链接对应的广告列表，通过落地页url反查广告
     *
     * @return 返回全量数据 key-落地页url，value-广告ID和名称
     */
    Map<String, List<AdvertBaseInfoDto>> queryPromoteUrlAdvertList();

    /**
     * 用于风控系统更新广告位定向导量数据
     * 注意：此接口会全量更新广告位定向导量表里的数据
     *
     * @param list 广告位定向导量数据list
     * @return
     */
    int updateSlotDirectionData(List<SlotDirectionDto> list);

    /**
     * 更新定向广告id
     *
     * @param advertId
     */
    void updateDirectionAdvertId(Long advertId);

    /**
     * 用于风控系统冻结或解冻广告主操作，未抛异常说明操作成功
     *
     * @param advertiserId  广告主id
     * @param freezeStatus  冻结状态:0-未冻结;1-冻结
     * @param frozenReason  冻结原因
     * @param auditor       审核人
     */
    void frozenAdvertiserAccount(Long advertiserId, Integer freezeStatus, String frozenReason, String auditor) throws BizException;

    /**
     * 根据广告主id批量查询广告主（简要）信息
     *
     * @param advertiserIds 广告主id集合
     * @return
     */
    List<AdvertiserSimpleDto> queryAdvertiserSimpleInfoByIds(List<Long> advertiserIds);


    /**
     * 广告端将钟馗同步过来的媒体，自动写入指定的流量包
     *
     * @param cheatAppMap 作弊媒体集合
     * @return
     */
    void getCheatApp(Map<Integer, List<Long>> cheatAppMap);

    /**
     * 根据广告主id 查询该广告主对应的一级代理商下所有广告主名称
     */
    Map<Long,List<String>> getOneAgentNames(List<Long> accountIds);

    /**
     * 根据广告主id 查询该广告主对应的一级代理商的收件邮箱
     */
    Map<Long,String> getOneAgentEmail(List<Long> accountIds);

    /**
     * 广告计划&素材审核钉钉定时提醒 测试接口
     */
    void advertCheckDingJob();


    /**
     * 通过slotId列表查询广告位绑定的广告计划.
     * @param slotIds
     * @return
     */
    List<SlotWhiteListDto> getWhiteListBySlotIds(List<Long> slotIds);
}
