package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("查询广告每日统计数据请求参数")
public class GetAppHourData implements Serializable {

    @NotNull(message = "广告ID不为空")
    @ApiModelProperty(value = "广告ID", required = true)
    private Long advertId;

    @NotNull
    @ApiModelProperty("日期")
    private String curDate;

    @NotNull
    @ApiModelProperty("时段")
    private Integer[] periodList;

    @ApiModelProperty("应用id")
    private Long[] appIds;

    @ApiModelProperty("应用标签")
    private String[] appTag;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("排序字段")
    private String sort;

    @ApiModelProperty("排序字段")
    private String order;

    private Integer pageSize;

    private Integer currentPage;


    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public Integer[] getPeriodList() {
        return periodList;
    }

    public void setPeriodList(Integer[] periodList) {
        this.periodList = periodList;
    }

    public Long[] getAppIds() {
        return appIds;
    }

    public void setAppIds(Long[] appIds) {
        this.appIds = appIds;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String[] getAppTag() {
        return appTag;
    }

    public void setAppTag(String[] appTag) {
        this.appTag = appTag;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }
}
