package cn.com.duiba.tuia.core.api.dto.advert;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

public class AdvertAbnormalMonitoringDto extends BaseDto {

    private static final long serialVersionUID = 8402054624246129361L;

    /** 广告id */
    private Long              advertId;

    /** 配置id */
    private String              orientId;

    /**
     * 监控目标：1-广告，2-配置，3-广告下媒体，4-配置下媒体
     * 
     * @AbnormalMonitoringTargetTypeEnum
     */
    private Integer           targetType;

    /**
     * 监控内容：1-失效，2-消耗，3-落地页到达率，4-落地页成本，5-注册成本，6-激活成本，7-APP启动成本
     * 
     * @AbnormalMonitoringContentTypeEnum
     */
    private Integer           contentType;

    /**
     * 前置条件：1-广告消耗，2-配置消耗，3-单媒体消耗，4-单媒体发券，5-广告计费点击，6-配置计费点击
     * 
     * @AbnormalMonitoringConditionTypeEnum
     */
    private Integer           conditionType;

    /** 前置条件阈值 */
    private String            conditionValue;

    /**
     * 监控规则：1-昨日同时段累计值环比上下波动，2-昨日同时段累计值环比上升，3-昨日同时段累计值环比下降，4-今日累计高于，5-今日累计低于
     * 
     * @AbnormalMonitoringRuleTypeEnum
     */
    private Integer           ruleType;

    /** 监控规则阈值 */
    private String            ruleValue;

    /**
     * 监控规则：1-钉钉提醒，2-暂停计划并发送钉钉提醒，3-关闭配置并发送钉钉提醒，4-仅自动加入限流媒体，5-自动加入限流媒体并发送钉钉提醒
     * 
     * @AbnormalMonitoringHandleTypeEnum
     */
    private Integer           handleType;

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    

    
    /**
     * orientId.
     *
     * @return  the orientId
     * @since   JDK 1.8
     */
    public String getOrientId() {
        return orientId;
    }

    
    /**
     * orientId.
     *
     * @param   orientId    the orientId to set
     * @since   JDK 1.8
     */
    public void setOrientId(String orientId) {
        this.orientId = orientId;
    }

    /**
     * targetType.
     *
     * @return the targetType
     * @since JDK 1.8
     */
    public Integer getTargetType() {
        return targetType;
    }

    /**
     * targetType.
     *
     * @param targetType the targetType to set
     * @since JDK 1.8
     */
    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    /**
     * contentType.
     *
     * @return the contentType
     * @since JDK 1.8
     */
    public Integer getContentType() {
        return contentType;
    }

    /**
     * contentType.
     *
     * @param contentType the contentType to set
     * @since JDK 1.8
     */
    public void setContentType(Integer contentType) {
        this.contentType = contentType;
    }

    /**
     * conditionType.
     *
     * @return the conditionType
     * @since JDK 1.8
     */
    public Integer getConditionType() {
        return conditionType;
    }

    /**
     * conditionType.
     *
     * @param conditionType the conditionType to set
     * @since JDK 1.8
     */
    public void setConditionType(Integer conditionType) {
        this.conditionType = conditionType;
    }

    /**
     * ruleType.
     *
     * @return the ruleType
     * @since JDK 1.8
     */
    public Integer getRuleType() {
        return ruleType;
    }

    /**
     * ruleType.
     *
     * @param ruleType the ruleType to set
     * @since JDK 1.8
     */
    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    /**
     * conditionValue.
     *
     * @return the conditionValue
     * @since JDK 1.8
     */
    public String getConditionValue() {
        return conditionValue;
    }

    /**
     * conditionValue.
     *
     * @param conditionValue the conditionValue to set
     * @since JDK 1.8
     */
    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
    }

    /**
     * ruleValue.
     *
     * @return the ruleValue
     * @since JDK 1.8
     */
    public String getRuleValue() {
        return ruleValue;
    }

    /**
     * ruleValue.
     *
     * @param ruleValue the ruleValue to set
     * @since JDK 1.8
     */
    public void setRuleValue(String ruleValue) {
        this.ruleValue = ruleValue;
    }

    /**
     * handleType.
     *
     * @return the handleType
     * @since JDK 1.8
     */
    public Integer getHandleType() {
        return handleType;
    }

    /**
     * handleType.
     *
     * @param handleType the handleType to set
     * @since JDK 1.8
     */
    public void setHandleType(Integer handleType) {
        this.handleType = handleType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
