/**
 * Project Name:tuia-advert-center-api File Name:TradeTagRuleDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.rsp.tradeTagRule Date:2018年3月21日上午11:25:42 Copyright (c) 2018, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.orientPkg;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 
 * ClassName: OrientPkgExpandDto <br/>
 * Function: 定向配置拓展DTO. <br/>
 * date: 2019年5月17日 上午11:15:34 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public class OrientPkgExpandDto extends BaseDto {

    private static final long serialVersionUID = 7705206860543368592L;

    /** 广告id. */
    private Long    advertId;

    /** 配置id. */
    private Long    orientId;

    /** 引擎用到的配置id，默认配置id为0，自定义配置id不变. */
    private Long    defaultOrientId;

    /** 应急广告填充类型，0-正常配置，1-系统填充. */
    private Integer urgentType;

    /**
     * 托管底价控制 白名单标记
     */
    private String tag;

    public Long getDefaultOrientId() {
        return defaultOrientId;
    }

    public void setDefaultOrientId(Long defaultOrientId) {
        this.defaultOrientId = defaultOrientId;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * orientId.
     *
     * @return the orientId
     * @since JDK 1.8
     */
    public Long getOrientId() {
        return orientId;
    }

    /**
     * orientId.
     *
     * @param orientId the orientId to set
     * @since JDK 1.8
     */
    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    /**
     * urgentType.
     *
     * @return the urgentType
     * @since JDK 1.8
     */
    public Integer getUrgentType() {
        return urgentType;
    }

    /**
     * urgentType.
     *
     * @param urgentType the urgentType to set
     * @since JDK 1.8
     */
    public void setUrgentType(Integer urgentType) {
        this.urgentType = urgentType;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
