package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: ResourceTagsTypeEnum <br/>
 * Function: 资源对应标签类型. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum NewTagsNumEnum {

    /** 行业标签 */
    ADVERT_TAG("02", "广告标签"),
    
    /** 属性标签 */
    BANNED_TAG("03", "属性标签"),
    
    /**落地页标签 */
    PROMOTEURL("04", "落地页标签"),

    /** 素材标签 */
    MATERIAL("05", "素材标签"),
    
    /** 分析标签 */
    ANALYSIS("06", "分析标签"),

    /** 资源标签 */
    RESOURCE_TAG("07", "资源标签")

    ;

    private String desc;

    private String code;

    NewTagsNumEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, NewTagsNumEnum> enumMap = Maps.newHashMap();
    static {
        for (NewTagsNumEnum it : NewTagsNumEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static NewTagsNumEnum getByName(String code) {
        return enumMap.get(code);
    }
}
