package cn.com.duiba.tuia.core.api.message;

import cn.com.duiba.wolf.utils.DateUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告状态变化消息
 * Created by zhengjy on 2017/5/10.
 */
public class AdvertValidStatusEditMessage implements Serializable {

    private static final long serialVersionUID = 1468732344270278793L;

    private Long advertId;//广告id
    private Integer src;//广告变更源状态
    private Integer	des;//目标状态
    private Date time;//变化时间

    public AdvertValidStatusEditMessage(Long advertId, Integer src, Integer des) {
        this.advertId = advertId;
        this.src = src;
        this.des = des;
        this.time = new Date();
    }


    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getSrc() {
        return src;
    }

    public void setSrc(Integer src) {
        this.src = src;
    }

    public Integer getDes() {
        return des;
    }

    public void setDes(Integer des) {
        this.des = des;
    }

    public String getTime() {
        return DateUtils.getSecondStr(time.getTime());
    }

}
