package cn.com.duiba.tuia.core.api.remoteservice.data;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.data.PackageAdvertDayDto;
import cn.com.duiba.tuia.core.api.dto.req.data.ReqPackageAdvertDayDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by zhengjy on 2017/6/16.
 */
@AdvancedFeignClient
public interface RemotePackageAdvertDayService {
    /**
     * 广告定向配置列表查询
     * @param req
     * @return
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
    DubboResult<PageDto<PackageAdvertDayDto>> selectPackageAdvertDayPage(ReqPackageAdvertDayDto req);

    /**
     * 
     * selectByAdvertIs:(查询广告下定向配置数据). <br/>
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    List<PackageAdvertDayDto> selectByAdvertId(ReqPackageAdvertDayDto req);
}
