package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: ProductNameTagEnum <br/>
 * Function: 商品名称标签类型. <br/>
 * date: 2018-11-22. <br/>
 *
 * @author jiafeng.geng
 */
public enum ProductNameTagEnum {

    /* 静态素材名称 */
    STATIC_MATERIAL_NAME(0, "静态素材名称"),

    /* 投放地域：省 */
    PUT_REGIONAL_PROVINCE(1, "投放地域：省"),

    /* 网络类型 */
    NETWORK_TYPE(2, "网络类型"),

    /* 运营商 */
    NETWORK_OPERATOR(3, "运营商"),

    /* 操作系统 */
    OPERATING_SYSTEM(4, "操作系统"),

    /* 日期 */
    DATE(5, "日期"),

    /* 投放地域：市 */
    PUT_REGIONAL_CITY(6, "投放地域：市");

    private Integer code;

    private String desc;

    ProductNameTagEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, ProductNameTagEnum> enumMap = Maps.newHashMap();

    static {
        for (ProductNameTagEnum it : ProductNameTagEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static ProductNameTagEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
