package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertsCheckRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/23 11:36
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertsCheckRecordBackendService {

    /**
     * 保存广告状态更改记录.
     *
     * @param checkRecord checkRecord
     * @return 新增记录的主键id
     */
    DubboResult<Integer> insert(AdvertsCheckRecordDto checkRecord);

    /**
     * 查询广告的审核记录.
     *
     * @param advertId 广告ID
     * @return 最新的审核记录
     */
    DubboResult<List<AdvertsCheckRecordDto>> selectByAdvertId(Long advertId);

    /**
     * 指定广告是否有指定类型审核记录.
     *
     * @param advertId  广告ID
     * @param checkType 审核类型
     * @return 符合条件的记录数
     */
    DubboResult<Integer> getCheckRecordByAdvertIdAndCheckType(Long advertId, Integer checkType);

    /**
     * 根据广告id 维度汇总审核记录数量
     */
    List<AdvertsCheckRecordDto> getCountGroupByAdvertId(List<Long> advertIds);

    /**
     * 根据广告id 查询审核记录信息
     */
    List<AdvertsCheckRecordDto> getCheckRecordByAdvertId(Long advertId);
}
