package cn.com.duiba.tuia.core.api.enums.statistics;

import cn.com.duiba.tuia.core.api.dto.statistics.TitleHeader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 
 * ClassName: AdvertAppStatisticsTitleEnum <br/>
 * Function: 每日广告应用数据标题. <br/>
 * date: 2018年4月20日 下午2:15:47 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertAppStatisticsTitleEnum {

    /** 应用ID */
    APP_ID(0, "appId", "应用ID"),
    
    /** 应用名称 */
    APP_NAME(0, "name", "应用名称"),
    
    /** 应用标签 */
    TAG_NAME(0, "tagName", "应用标签"),

    /** 消费 */
    CONSUME_TOTAL(0, "consumeTotal", "消费"),
    
    /** 应用来源 */
    APP_SOURCE(0, "appSource", "应用来源"),

    /** 应用状态 */
    APP_STATUS(0, "appStatus", "应用状态"),

    /** 消费可疑*/
    CHEAT_CONSUME(0, "cheatConsume", "消费(可疑)"),

    /** 转化成本 */
    COST(0, "cost", "转化成本"),

    /** 成本变化 */
    COST_CHANGE(0, "costChange", "成本变化"),

    /** 发券pv */
    LAUNCH_COUNT(0, "launchCount", "发券pv"),

    /** 计费点击pv */
    EF_CLICK_COUNT(0, "efClickCount", "计费点击pv"),

    /** CTR */
    CLICK_RATE(0, "clickRate", "CTR"),

    /** 落地页访问PV */
    VISIT_PV(0, "visitPv", "落地页访问PV"),

    /** 落地页到达率 */
    LOSS(0, "loss", "落地页到达率"),

    /** 转化PV */
    EFFECT_PV(0, "effectPv", "转化PV"),

    /** CVR */
    CVR(0, "cvr", "CVR"),

    /** 计费点击均价 */
    AVERAGE_PRICE(3, "averagePrice", "计费点击均价");


    
    /** 类型：0-公用，1-页面展示标题，2-导出标题,3-转化数据后追加的公用标题，4-转化数据后追加的展示标题，5-转化数据后追加的导出标题 */
    private Integer type;
    
    private String code;

    private String desc;
  
    private AdvertAppStatisticsTitleEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    public static AdvertAppStatisticsTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }
    

    private static Map<String, AdvertAppStatisticsTitleEnum> enumMap = Maps.newHashMap();
    /** 固定数据标题 */
    private static List<TitleHeader> advertAppStatisticsTitleList = new ArrayList<>(AdvertAppStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertAppStatisticsExporyTitleList = new ArrayList<>(AdvertAppStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertAppOtherTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);
    private static List<TitleHeader> advertAppOtherExportTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);
    static {
        for (AdvertAppStatisticsTitleEnum it : AdvertAppStatisticsTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
            switch (it.type) {
                case 0:
                    advertAppStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    advertAppStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 1:
                    advertAppStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 2:
                    advertAppStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 3:
                    advertAppOtherTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 5:
                    advertAppOtherExportTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 
     * getAdvertAppStatisticsTitle:(获取转化标题前固定标题，1-展示，2-导出). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public static List<TitleHeader> getAdvertAppStatisticsTitle(Integer type) {
        if (type.intValue() == 1) {
            return BeanUtils.copyList(advertAppStatisticsTitleList, TitleHeader.class);
        }else{
            return BeanUtils.copyList(advertAppStatisticsExporyTitleList, TitleHeader.class);
        }
    }
    
    /**
     * 
     * addOtherTitle:(其他标题追加，转化数据标题放在这些标题之前). <br/>
     *
     * @author chencheng
     * @param advertAppStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherTitle(List<TitleHeader> advertAppStatisticsTitle) {
        
        advertAppStatisticsTitle.addAll(advertAppOtherTitleList);
    }
    
    /**
     * 
     * addOtherTitle:(转化数据后追加的导出标题). <br/>
     *
     * @author chencheng
     * @param advertDayStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherExportTitleList(List<TitleHeader> advertDayStatisticsTitle) {
        advertDayStatisticsTitle.addAll(advertAppOtherExportTitleList);
    }
}
