/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年8月19日下午4:22:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertPatrolDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertReviewDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertRiskService {

    /**
     * 广告审核通过或者拒绝插入复审巡检记录表
     *
     * @param record
     * @return
     */
    int insertSelective(AdvertReviewDto record);

    /**
     * 通过广告id作为主键更新复审巡检记录
     */
    int updateByAdvertIdSelective(AdvertReviewDto record);

    /**
     * 通过广告id查询数据
     *
     * @param advertId 广告id是唯一键
     */
    AdvertReviewDto selectByAdvertId(Long advertId);

    /**
     * 通过广告Id列表批量查询广告名称,AE,销售信息.
     */
    List<AdvertPatrolDto> getAdvertsByIds(List<Long> advertIds);
}
