package cn.com.duiba.tuia.core.api.remoteservice.land;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.land.LandPageDiagnosisResultDto;
import cn.com.duiba.tuia.core.api.dto.land.LandPageDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.LandPageDiagCenterDto;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2019/7/24 10:17
 */
@AdvancedFeignClient
public interface RemoteLandPageQueryService {

    /**
     * @return 影响行数
     */
    int insert(LandPageDto landPageDto);

    /**
     * @param advertId 广告ID
     * @param md5Url md5加密的url
     * @return
     */
    Long getId(Long advertId,String md5Url);

    /**
     * 查询总数
     *
     * @return 当前总数量
     */
    Long count(LandPageDiagCenterDto dto);


    /**
     * @return 查询列表
     */
    List<LandPageDiagnosisResultDto> listDiagnosisResult(LandPageDiagCenterDto dto);


    /**
     * @return 当前用户可以看到的被诊断的落地页的Id
     */
    List<Long> findAllIdByAdvertIds(LandPageDiagCenterDto dto);

    /**
     * @param ids 被诊断的页面ID
     * @return 被诊断的页面信息
     */
    List<LandPageDiagnosisResultDto> listResultByIds(List<Long> ids);

    /**
     * 【批量】删除落地页诊断结果数据表数据
     *
     * @param pageIdList
     */
    void deleteByPageIdList(List<Long> pageIdList);

    /**
     * 【单个】删除落地页诊断结果数据表数据
     */
    void deleteByDiagnosisId(Long diagnosisId);

}
