/**
 * Project Name:tuia-advert-web-domain File Name:QualificationRsp.java Package Name:cn.com.duiba.tuia.domain.model.rsp
 * Date:2017年11月27日上午10:54:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.account;

import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationAuditDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;

/**
 * ClassName:QualificationRsp <br/>
 * Function: 广告主资质信息. <br/>
 * Date: 2017年11月27日 上午10:54:08 <br/>
 *
 * @author chencheng
 * @see
 * @since JDK 1.8
 */
@ApiModel("广告主资质信息参数")
public class QualificationAuditDto extends AccountLevelDto {

    private static final long serialVersionUID = -3219399191779427812L;

    /**
     * 广告主账号.
     */
    @ApiModelProperty("广告主账号.")
    private Long accountId;

    /**
     * 资质资源ID.
     */
    @ApiModelProperty("资质资源ID.")
    private Long qualificationId;

    /**
     * 资质资源名称.
     */
    @ApiModelProperty("资质资源名称.")
    private String qualificationName;

    /**
     * 行业ID.
     */
    @ApiModelProperty("行业ID.")
    private Long tradeId;

    /**
     * 行业名称.
     */
    @ApiModelProperty("行业名称.")
    private String tradeName;

    /**
     * 资质图片url.
     */
    @ApiModelProperty("资质图片url.")
    private String qualificationUrl;

    /**
     * 有效期.
     */
    @ApiModelProperty("有效期.")
    private String qualificationValidity;

    /**
     * 审核状态：0-待审，1-通过，2-拒绝.
     */
    @ApiModelProperty("审核状态：0-待审，1-通过，2-拒绝.")
    private Integer checkStatus;

    /**
     * 备注.
     */
    @ApiModelProperty("备注.")
    private String remark;

    /**
     * 拒绝原因.
     */
    @ApiModelProperty("拒绝原因.")
    private String reason;

    /**
     * 行业拒绝原因.
     */
    @ApiModelProperty("行业拒绝原因.")
    private String tradeReason;

    /**
     * 编辑时间
     */
    private Date editTime;

    /**
     * 审核人
     */
    private String auditor;

    /**
     * 审核时间
     */
    private Date auditTime;

    //AE Email
    private String aeEmail;
    //销售Email
    private String sellEmail;
    //广告主名称
    private String accountName;
    //AE Email
    private String aeDingid;
    //销售Email
    private String sellDingid;

    @ApiModelProperty("待审数量")
    private Integer waitCount;
    @ApiModelProperty("审核通过数量")
    private Integer passCount;
    @ApiModelProperty("审核拒绝数量")
    private Integer refuseCount;
    @ApiModelProperty("资质包列表.")
    private List<QualificationPackageDto> packageList;
    /** 进审时间 */
    private Date enterCheckTime;
    /** 审核时长(s) */
    private Long checkLoadTime;


    /**
     * accountId.
     *
     * @return the accountId
     * @since JDK 1.8
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * accountId.
     *
     * @param accountId the accountId to set
     * @since JDK 1.8
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * tradeReason.
     *
     * @return the tradeReason
     * @since JDK 1.8
     */
    public String getTradeReason() {
        return tradeReason;
    }

    /**
     * tradeReason.
     *
     * @param tradeReason the tradeReason to set
     * @since JDK 1.8
     */
    public void setTradeReason(String tradeReason) {
        this.tradeReason = tradeReason;
    }

    /**
     * reason.
     *
     * @return the reason
     * @since JDK 1.8
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     * @since JDK 1.8
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * qualificationId.
     *
     * @return the qualificationId
     * @since JDK 1.8
     */
    public Long getQualificationId() {
        return qualificationId;
    }

    /**
     * qualificationId.
     *
     * @param qualificationId the qualificationId to set
     * @since JDK 1.8
     */
    public void setQualificationId(Long qualificationId) {
        this.qualificationId = qualificationId;
    }

    /**
     * qualificationName.
     *
     * @return the qualificationName
     * @since JDK 1.8
     */
    public String getQualificationName() {
        return qualificationName;
    }

    /**
     * qualificationName.
     *
     * @param qualificationName the qualificationName to set
     * @since JDK 1.8
     */
    public void setQualificationName(String qualificationName) {
        this.qualificationName = qualificationName;
    }

    /**
     * tradeId.
     *
     * @return the tradeId
     * @since JDK 1.8
     */
    public Long getTradeId() {
        return tradeId;
    }

    /**
     * tradeId.
     *
     * @param tradeId the tradeId to set
     * @since JDK 1.8
     */
    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    /**
     * tradeName.
     *
     * @return the tradeName
     * @since JDK 1.8
     */
    public String getTradeName() {
        return tradeName;
    }

    /**
     * tradeName.
     *
     * @param tradeName the tradeName to set
     * @since JDK 1.8
     */
    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    /**
     * qualificationUrl.
     *
     * @return the qualificationUrl
     * @since JDK 1.8
     */
    public String getQualificationUrl() {
        return qualificationUrl;
    }

    /**
     * qualificationUrl.
     *
     * @param qualificationUrl the qualificationUrl to set
     * @since JDK 1.8
     */
    public void setQualificationUrl(String qualificationUrl) {
        this.qualificationUrl = qualificationUrl;
    }

    /**
     * qualificationValidity.
     *
     * @return the qualificationValidity
     * @since JDK 1.8
     */
    public String getQualificationValidity() {
        return qualificationValidity;
    }

    /**
     * qualificationValidity.
     *
     * @param qualificationValidity the qualificationValidity to set
     * @since JDK 1.8
     */
    public void setQualificationValidity(String qualificationValidity) {
        this.qualificationValidity = qualificationValidity;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.8
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.8
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.8
     */
    public String getRemark() {
        return remark;
    }

    public Date getEditTime() {
        return editTime;
    }

    public void setEditTime(Date editTime) {
        this.editTime = editTime;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.8
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public QualificationAuditDto() {
        super();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static Boolean compareIfUpdate(ReqQualificationAuditDto nowDto, QualificationAuditDto beforeDto) {
        // 任何一个为null，不更新
        if (nowDto == null || beforeDto == null) {
            return false;
        }
        // 资质资源id,url,有效期任何一个有改动则修改
        if (!nowDto.getQualificationId().equals(beforeDto.getQualificationId())) {
            return true;
        }
        if (!nowDto.getQualificationUrl().equals(beforeDto.getQualificationUrl())) {
            return true;
        }
        if (!nowDto.getQualificationValidity().equals(beforeDto.getQualificationValidity())) {
            return true;
        }
        return false;
    }

    public String getAeEmail() {
        return aeEmail;
    }

    public void setAeEmail(String aeEmail) {
        this.aeEmail = aeEmail;
    }

    public String getSellEmail() {
        return sellEmail;
    }

    public void setSellEmail(String sellEmail) {
        this.sellEmail = sellEmail;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAeDingid() {
        return aeDingid;
    }

    public void setAeDingid(String aeDingid) {
        this.aeDingid = aeDingid;
    }

    public String getSellDingid() {
        return sellDingid;
    }

    public void setSellDingid(String sellDingid) {
        this.sellDingid = sellDingid;
    }

    public Integer getWaitCount() {
        return waitCount;
    }

    public void setWaitCount(Integer waitCount) {
        this.waitCount = waitCount;
    }

    public Integer getPassCount() {
        return passCount;
    }

    public void setPassCount(Integer passCount) {
        this.passCount = passCount;
    }

    public Integer getRefuseCount() {
        return refuseCount;
    }

    public void setRefuseCount(Integer refuseCount) {
        this.refuseCount = refuseCount;
    }

    public List<QualificationPackageDto> getPackageList() {
        return packageList;
    }

    public void setPackageList(List<QualificationPackageDto> packageList) {
        this.packageList = packageList;
    }

    public Date getEnterCheckTime() {
        return enterCheckTime;
    }

    public void setEnterCheckTime(Date enterCheckTime) {
        this.enterCheckTime = enterCheckTime;
    }

    public Long getCheckLoadTime() {
        return checkLoadTime;
    }

    public void setCheckLoadTime(Long checkLoadTime) {
        this.checkLoadTime = checkLoadTime;
    }
}
