package cn.com.duiba.tuia.core.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;

/**
 * 广告计划赔付分页查询参数
 *
 * @author peanut.huang
 * @date 2019/10/15
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class CompensatePagingParam extends BaseQueryReq implements Serializable{

    private static final long serialVersionUID = 7417325376189417895L;


    /**
     * 要赔付的日期起始
     */
    private String          startDate;

    /**
     * 要赔付的日期结束
     */
    private String          endDate;

    /**
     * 计划id
     */
    private Long            advertId;


    /**
     * 赔付状态 {@link cn.com.duiba.tuia.core.api.enums.compensate.CompensateStatusEnum#status}
     */
    private Integer         compensateStatus;

    /**
     * 赔付开关 {@link cn.com.duiba.tuia.core.api.enums.compensate.CompensateSwitchEnum#status}
     */
    private Integer         compensateSwitch;
}
