package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AppFlowStrategyDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotEffectiveAdvertNumInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotFlowStrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by jzl on 18/4/2.
 */
@AdvancedFeignClient
public interface RemoteSlotFlowStrategyService {

    /**
     * 通过appId查询策略集合
     * @param appId
     * @return
     */
    DubboResult<List<SlotFlowStrategyDto>> getListByAppId(Long appId);

    /**
     * 查询单个广告位的策略
     * @param slotId
     * @return
     */
    DubboResult<SlotFlowStrategyDto> findSlotFlowStrategyDtoBySlotId(Long slotId);

    List<SlotFlowStrategyDto> selectBySlotIds(List<Long> slotIds);

    /**
     * 更改福袋开关状态
     */
    Boolean updateSendLuckybag(Long slotId, Integer isSendLuckybag);

    /**
     * 插入广告位流量策略
     *
     * @param  slotFlowStrategyDto
     */
    DubboResult<Boolean> insertOrUpdateSlotFlowStrategy(SlotFlowStrategyDto slotFlowStrategyDto);

    /**
     * 计算广告位的总广告数和有效广告数
     * @param slotIds
     * @return
     */
    List<SlotEffectiveAdvertNumInfoDto> handleSlotsAdvertNumInfo(List<Long> slotIds);

    /**
     * 根据appId查询下属的流量策略所有的广告位id
     * @param appId
     * @return
     */
    List<Long> getFlowStrategySlotIdsByAppId(Long appId);

    /**
     * 通过appId查询策略集合(getListByAppId，为了解决limit 100的问题)
     *
     * @param appId 媒体Id
     * @param start 开始位置
     * @param offset 偏移量
     * @return
     */
    List<SlotFlowStrategyDto> getListByAppIdExt(Long appId,long start,int offset);

    /**
     * 根据媒体Id 获取广告位数量
     *
     * @param appId 媒体Id
     * @return
     */
    Long countSlotByAppId(Long appId);
}
