/**
 * Project Name:tuia-advert-center-api File Name:ReqQualificationAuditDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.req.qualification Date:2017年11月30日下午7:49:44 Copyright (c) 2017, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.qualification;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.QueryDto;

/**
 * ClassName:ReqQualificationAuditDto <br/>
 * Function: 资质审核基本信息dto. <br/>
 * Date: 2017年11月30日 下午7:49:44 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public class ReqQualificationAuditDto extends QueryDto {

    private static final long   serialVersionUID    = 7495794582159852980L;

    /** 审核状态：0-待审 */
    public static final Integer CHECK_STATUS_WAIT   = 0;
    /** 审核状态：1-通过 */
    public static final Integer CHECK_STATUS_PASS   = 1;
    /** 审核状态：2-拒绝 */
    public static final Integer CHECK_STATUS_REFUSE = 2;

    /** id. */
    private Long                id;

    /** 广告主账号. */
    private Long                accountId;

    /** 资质资源ID. */
    private Long                qualificationId;

    /** 资质图片url. */
    private String              qualificationUrl;

    /** 有效期. */
    private String              qualificationValidity;

    /** 审核状态：0-待审，1-通过，2-拒绝. */
    private Integer             checkStatus;

    /** 备注. */
    private String              remark;

    /** 拒绝原因. */
    private String              reason;

    /** 审核人 */
    private String auditor;

    /** 审核时间 */
    private Date auditTime;

    /** 资质包状态：0:正常;1：异常 */
    private Integer           packageStatus;
    /** 资质id列表 */
    private List<Long> qualificationIds;
    /** 审核时长(s) */
    private Long checkLoadTime;
    /** 进审时间 */
    private Date enterCheckTime;

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.8
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.8
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * accountId.
     *
     * @return the accountId
     * @since JDK 1.8
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * accountId.
     *
     * @param accountId the accountId to set
     * @since JDK 1.8
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * qualificationId.
     *
     * @return the qualificationId
     * @since JDK 1.8
     */
    public Long getQualificationId() {
        return qualificationId;
    }

    /**
     * qualificationId.
     *
     * @param qualificationId the qualificationId to set
     * @since JDK 1.8
     */
    public void setQualificationId(Long qualificationId) {
        this.qualificationId = qualificationId;
    }

    /**
     * qualificationUrl.
     *
     * @return the qualificationUrl
     * @since JDK 1.8
     */
    public String getQualificationUrl() {
        return qualificationUrl;
    }

    /**
     * qualificationUrl.
     *
     * @param qualificationUrl the qualificationUrl to set
     * @since JDK 1.8
     */
    public void setQualificationUrl(String qualificationUrl) {
        this.qualificationUrl = qualificationUrl;
    }

    /**
     * qualificationValidity.
     *
     * @return the qualificationValidity
     * @since JDK 1.8
     */
    public String getQualificationValidity() {
        return qualificationValidity;
    }

    /**
     * qualificationValidity.
     *
     * @param qualificationValidity the qualificationValidity to set
     * @since JDK 1.8
     */
    public void setQualificationValidity(String qualificationValidity) {
        this.qualificationValidity = qualificationValidity;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.8
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.8
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.8
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.8
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * reason.
     *
     * @return the reason
     * @since JDK 1.8
     */
    public String getReason() {
        return reason;
    }

    /**
     * reason.
     *
     * @param reason the reason to set
     * @since JDK 1.8
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    public ReqQualificationAuditDto() {
        super();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getPackageStatus() {
        return packageStatus;
    }

    public void setPackageStatus(Integer packageStatus) {
        this.packageStatus = packageStatus;
    }

    public List<Long> getQualificationIds() {
        return qualificationIds;
    }

    public void setQualificationIds(List<Long> qualificationIds) {
        this.qualificationIds = qualificationIds;
    }

    public Long getCheckLoadTime() {
        return checkLoadTime;
    }

    public void setCheckLoadTime(Long checkLoadTime) {
        this.checkLoadTime = checkLoadTime;
    }

    public Date getEnterCheckTime() {
        return enterCheckTime;
    }

    public void setEnterCheckTime(Date enterCheckTime) {
        this.enterCheckTime = enterCheckTime;
    }
}
