package cn.com.duiba.tuia.core.api.enums;

import com.google.common.collect.Sets;

import java.util.Set;

/**
 * @author zhangmeng
 * @date 2019/10/8
 * @function 中国地理区域枚举
 *
 * 华北地区: 北京,天津,河北,山西,内蒙古     8000
 * 东北地区: 辽宁,吉林,黑龙江              8100
 * 华东地区: 上海，江苏，浙江，安徽，福建，江西，山东  8200
 * 华中地区: 河南，湖北，湖南                  8300
 * 华南地区: 广东，广西，海南                  8400
 * 西南地区: 重庆，四川，贵州，云南，西藏        8500
 * 西北地区: 陕西，甘肃，青海，宁夏，新疆        8600
 * 港澳台: 香港，澳门，台湾                    8700
 * 海外:                                     999
 * 其他:                                     0
 * @return
 */
public enum RegionEnum {

    NORTH_CHINA("8000","华北地区",Sets.newHashSet("北京","天津","河北","山西","内蒙古")),

    NORTHEAST_CHINA("8100","东北地区",Sets.newHashSet("辽宁","吉林","黑龙江")),

    EAST_CHINA("8200","华东地区",Sets.newHashSet("上海","江苏","浙江","安徽","福建","江西","山东")),

    CENTRAL_CHINA("8300","华中地区",Sets.newHashSet("河南","湖北","湖南")),

    SOUTH_CHINA("8400","华南地区",Sets.newHashSet("广东","广西","海南")),

    SOUTHWEST_CHINA("8500","西南地区",Sets.newHashSet("重庆","四川","贵州","云南","西藏")),

    NORTHWEST_CHINA("8600","西北地区",Sets.newHashSet("陕西","甘肃","青海","宁夏","新疆")),

    HAT_CHINA("8700","港澳台",Sets.newHashSet("香港","澳门","台湾")),

    ABROAD("999","海外",Sets.newHashSet()),

    OTHER("0","其他",Sets.newHashSet()),

    CHINA("10","中国",Sets.newHashSet()),

    CITY_OTHER("99","其他",Sets.newHashSet()),

    FIRST_LINE_CITY("1","一线城市",Sets.newHashSet("北京","天津","沈阳市","上海","南京市","苏州市","无锡市","杭州市","宁波市","青岛市","郑州市","武汉市","长沙市","东莞市","广州市","深圳市","重庆","成都市","西安市")),

    SECOND_LINE_CITY("2","二线城市",Sets.newHashSet("保定市","石家庄市","太原市","大连市","长春市","哈尔滨市","常州市","南通市","徐州市","嘉兴市","金华市","绍兴市","台州市","温州市","合肥市","福州市","泉州市","厦门市","南昌市","济南市","潍坊市","烟台市","佛山市","惠州市","中山市","南宁市","贵阳市","昆明市","兰州市","乌鲁木齐市")),

    THIRD_LINE_CITY("3","三线城市",Sets.newHashSet("沧州市","邯郸市","廊坊市","秦皇岛市","唐山市","邢台市","包头市","呼和浩特市","鞍山市","吉林市","大庆市","淮安市","连云港市","泰州市","宿迁市","盐城市","扬州市","镇江市","湖州市","蚌埠市","滁州市"
            ,"阜阳市","铜陵市","芜湖市","宁德市","莆田市","漳州市","其他","赣州市","九江市","上饶市","宜春市","菏泽市","济宁市","临沂市","威海市","淄博市","洛阳市","南阳市","商丘市","新乡市","信阳市","许昌市"
            ,"驻马店市","黄冈市","荆州市","襄阳市","宜昌市","常德市","衡阳市","湘潭市","岳阳市","株洲市","潮州市","江门市","揭阳市","汕头市","湛江市","肇庆市","珠海市","其他","桂林市","柳州市","海口市","三亚市","德阳市","绵阳市","遵义市","曲靖市","咸阳市","西宁市","银川市")),


    UNKNOW(null,"未知",Sets.newHashSet());



    private String code;

    private String region;

    private Set<String> hasRegions;

    RegionEnum(String code, String region, Set<String> hasRegions) {
        this.code = code;
        this.region = region;
        this.hasRegions = hasRegions;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Set<String> getHasRegions() {
        return hasRegions;
    }

    public void setHasRegions(Set<String> hasRegions) {
        this.hasRegions = hasRegions;
    }


    public static RegionEnum getCityLevelByName(String cityName){

        if(FIRST_LINE_CITY.getHasRegions().contains(cityName)){
            return FIRST_LINE_CITY;
        }else if(SECOND_LINE_CITY.getHasRegions().contains(cityName)){
            return SECOND_LINE_CITY;
        }else if(THIRD_LINE_CITY.getHasRegions().contains(cityName)){
            return THIRD_LINE_CITY;
        }else{
            return UNKNOW;
        }

    }
}
