package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AccountCheckRecordDto;
import cn.com.duiba.tuia.core.api.dto.AdvertiserSumInfoDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.AccountCheckRecordReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/23 16:35
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAccountCheckRecordService {

    /**
     * 添加广告主账号审核记录
     *
     * @param accountCheckRecord
     * @return
     */
    DubboResult<Integer> addCheckRecord(AccountCheckRecordDto accountCheckRecord);

    /**
     * 批量插入审核记录
     *
     * @param recordList
     * @return
     */
    DubboResult<Integer> batchInsertAccountCheckRecord(List<AccountCheckRecordDto> recordList);
    
    /**
     * 
     * selectAccountCheckRecordList:(查询审核记录). <br/>
     *
     * @author chencheng
     * @param accountCheckRecordDto 查询条件
     * @return
     * @since JDK 1.8
     */
    List<AccountCheckRecordDto> selectAccountCheckRecordList(AccountCheckRecordDto accountCheckRecordDto);


    /**
     * 获取到该帐号最后一条审核记录
     * @param accountIds 帐号id列表
     * @return
     */
    List<AccountCheckRecordDto> selectLastRefuseCheckRecordList(List<Long> accountIds);

    /**
     * 根据账户列表查询账号对应的审核记录
     * @param accountIds 帐号id列表
     * @return
     */
    List<AdvertiserSumInfoDto> getCheckRecordCountByAccountIds(List<Long> accountIds);

    /**
     * 分页查询账号审核记录
     * @param req 查询条件
     * @return
     */
    PageDto<AccountCheckRecordDto> queryPageAccountCheckRecord(AccountCheckRecordReq req);
}
