package cn.com.duiba.tuia.core.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.data.DataBackDto;
import cn.com.duiba.tuia.core.api.dto.data.UploadDateByOneLineDto;

import java.util.Date;
import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteAdvertBackStatisticsService
 * Function: 落地页回传数据 远程接口
 * Date:     2019/3/7 0007 下午 14:53
 */
@AdvancedFeignClient
public interface RemoteAdvertBackStatisticsService {

    /**
     * 根据 时间 和广告id查询 回传数据
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    List<DataBackDto> selectAdvertBackDataByAdvertIds(List<Long> advertIds, Date startDate, Date endDate);

    /**
     *
     * 批量 修改或更新 落地页上传数据
     */
    void batchUploadBackData(List<UploadDateByOneLineDto> datas);

    /**
     * 修改或者新增 后端回传数据
     * @param data
     */
    Integer uploadDataByArtificial(UploadDateByOneLineDto data);
}
