package cn.com.duiba.tuia.core.api.remoteservice.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.media.request.ReqMediaAdvertDto;
import cn.com.duiba.tuia.core.api.dto.media.response.RspMediaAdvertDto;
import cn.com.duiba.tuia.core.api.dto.media.response.RspMediaAeDto;

import java.util.List;


/**
 * @author zhangmeng
 * @function 提供广告在媒体投放信息接口
 * @date 2018.09.19
 */
@AdvancedFeignClient
public interface RemoteMediaAppService {

    /**
     * 获取在投广告/非在投广告
     */
    RspMediaAdvertDto getAdvertOrientPackageInfo(ReqMediaAdvertDto reqMediaAdvertDto);


    /**
     * 获取媒体返回的屏蔽/不可见媒体id ,同时将配置命中的媒体返回
     */
    List<Long> getMediaAdvertApp(Long orientPackId);

    /**
     * 获取有效广告对应的ae
     */
    List<RspMediaAeDto> getValidAdverts();


}
