/**
 * Project Name:tuia-domain File Name:GetAdvertStatisticsReq.java Package Name:cn.com.duiba.tuia.domain.model.req
 * Date:2016年8月15日下午7:43:32 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:GetAdvertStatisticsReq <br/>
 * Function: 查询广告统计数据. <br/>
 * Date: 2016年8月15日 下午7:43:32 <br/>
 * 
 * @author leiliang
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqGetAdvertStatisticsDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** 代理商ID. */
    private Long              agentId;

    /** 广告主ID. */
    private Long              advertiserId;

    /** 广告主ID列表，始终有值. */
    private List<Long>        ids;

    /**
     * Gets the agent id.
     *
     * @return the agent id
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * Sets the agent id.
     *
     * @param agentId the agent id
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * Gets the advertiser id.
     *
     * @return the advertiser id
     */
    public Long getAdvertiserId() {
        return advertiserId;
    }

    /**
     * Sets the advertiser id.
     *
     * @param advertiserId the advertiser id
     */
    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    /**
     * Gets the ids.
     *
     * @return the ids
     */
    public List<Long> getIds() {
        return ids;
    }

    /**
     * Sets the ids.
     *
     * @param ids the ids
     */
    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
