package cn.com.duiba.tuia.core.api.enums;


/**
 * 启用状态
 * Created by zhengjy on 2017/3/15.
 */
public enum EnableStatusEnum {
    /** 启用或是. */
    ENABLE_STATUS_TRUE(1,"启用"),

    /** 暂停或否. */
    ENABLE_STATUS_FALSE(0,"暂停"),

    /**不进行操作 */
    DO_NOTHING(-1,"无操作");


    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private EnableStatusEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static EnableStatusEnum getByCode(int code){
        for(EnableStatusEnum enumVal : EnableStatusEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
